	SettingsStaffMemberDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { OnSettingsStaffMemberDTGridProperties() }
		},
		{
		divider: true
    	},
    	{
    		img: 'SubFW/bmp/photo_album_blue.png',
			text: 'Photo album...',
			action: function(e, selector) { OnSettingsStaffMemberPhotoAlbum() }
    	}
	];

	SettingsStaffMemberJobDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { OnSettingsStaffMemberJobDTGridProperties() }
		}
	];


	let ssmImageFile = null;

	function InitSettingsStaffMemberPage ()
	{
		let ss = sessionStorage.getItem ( 'SettingsStaffMemberPageInitialized' );
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsStaffMemberPageInitialized', true );

		IdcSettingsStaffMemberDT = new C_DataTable ();
		IdcSettingsStaffMemberDT.DataSrcType	= 0;
		IdcSettingsStaffMemberDT.Ident 			= 'IdcSettingsStaffMemberDT';
		IdcSettingsStaffMemberDT.Container 		= 'IdcSSMDTContainer';
		IdcSettingsStaffMemberDT.DataSrc 		= 'SubFW/database/settings/GetDTStaffMember.php';
		IdcSettingsStaffMemberDT.DataFct		= SettingsStaffMemberDTGetData;
		IdcSettingsStaffMemberDT.SetColReorder 	( false );
		IdcSettingsStaffMemberDT.OnSelect		( SettingsStaffMemberListDTSelected );
		IdcSettingsStaffMemberDT.AddColumn 		( 'id',							'id',	 				0, false,  0,  50, 		false, '', 	'' );
		IdcSettingsStaffMemberDT.AddColumn 		( 'civility_id',				'civility_id', 			1, false,  1, '50%', 	false, '', 	'' );
		IdcSettingsStaffMemberDT.AddColumn 		( Translate('Civility'),		'civility_name',		1, true,   2, '20%', 	true,  '', 	'', Translate );
		IdcSettingsStaffMemberDT.AddColumn 		( Translate('Lastname'),		'lastname',	 			1, true,   3, '40%', 	true,  '', 	'' );
		IdcSettingsStaffMemberDT.AddColumn 		( Translate('Firstname'),		'firstname',	 		1, true,   4, '40%', 	true,  '', 	'' );
		IdcSettingsStaffMemberDT.AddColumn 		( 'Login',						'login',		 		0, false,  5, '50%', 	true,  '', 	'' );
		IdcSettingsStaffMemberDT.AddColumn 		( 'Password',					'password',		 		0, false,  6, '50%', 	true,  '', 	'' );
		IdcSettingsStaffMemberDT.AddColumn 		( 'EMail',						'email',		 		0, false,  7, '50%', 	true,  '', 	'' );
		IdcSettingsStaffMemberDT.AddColumn 		( 'login_role_id',				'login_role_id',		0, false,  8, '50%', 	true,  '', 	'' );
		IdcSettingsStaffMemberDT.AddColumn 		( 'active',						'active',				0, false,  9, '50%', 	true,  '', 	'' );
		IdcSettingsStaffMemberDT.AddColumn 		( 'ris_name',					'ris_name',				0, false, 10, '50%', 	true,  '', 	'' );
		IdcSettingsStaffMemberDT.AddColumn 		( 'pacs_name',					'pacs_name',			0, false, 11, '50%', 	true,  '', 	'' );
		IdcSettingsStaffMemberDT.AddColumn 		( 'dacs_name',					'dacs_name',			0, false, 12, '50%', 	true,  '', 	'' );
		IdcSettingsStaffMemberDT.LoadUserCfg 	( G_USE_ID );

		IdcSettingsStaffMemberJobDT = new C_DataTable ();
		IdcSettingsStaffMemberJobDT.DataSrcType		= 0;
		IdcSettingsStaffMemberJobDT.Ident 			= 'IdcSettingsStaffMemberJobDT';
		IdcSettingsStaffMemberJobDT.Container 		= 'IdcSSMJobDTContainer';
		IdcSettingsStaffMemberJobDT.DataSrc 		= 'SubFW/database/settings/GetDTStaffJob.php';
		IdcSettingsStaffMemberJobDT.DataFct			= SettingsStaffMemberJobDTGetData;
		IdcSettingsStaffMemberJobDT.SetColReorder 	( false );
		IdcSettingsStaffMemberJobDT.OnSelect		( SettingsStaffMemberJobListDTSelected );
		IdcSettingsStaffMemberJobDT.AddColumn 		( 'id',						'id',	 				0, false,  0,  50, 		false, '', 				'' );
		IdcSettingsStaffMemberJobDT.AddColumn 		( 'staff_role_id',			'staff_role_id',		0, false,  1,  50, 		false, '', 				'' );
		IdcSettingsStaffMemberJobDT.AddColumn 		( 'dep_id',					'dep_id',				0, false,  2,  50, 		false, '', 				'' );
		IdcSettingsStaffMemberJobDT.AddColumn 		( Translate('Institution'),	'institutionname',	 	1, true,   3, '50%', 	true,  '', 				'' );
		IdcSettingsStaffMemberJobDT.AddColumn 		( Translate('Department'),	'departmentname',	 	1, true,   4, '50%', 	true,  '', 				'' );
		IdcSettingsStaffMemberJobDT.AddColumn 		( Translate('Job'),			'rolename',			 	1, true,   5, '50%', 	true,  '', 				'' );
		IdcSettingsStaffMemberJobDT.AddColumn 		( Translate('From'),		'begdate',			 	1, true,   6, '30%', 	true,  'text-center', 	'', DICOMDate2StdDateFR );
		IdcSettingsStaffMemberJobDT.AddColumn 		( Translate('To'),			'enddate',			 	1, true,   7, '30%', 	true,  'text-center', 	'', DICOMDate2StdDateFR );
		IdcSettingsStaffMemberJobDT.LoadUserCfg 	( G_USE_ID );


		$(document).ready(function () 
		{
			IdcSSMSplitter1_2 	= new C_Splitter ( "IdcSSMSplitter1_2" );
			IdcSSMSplitter3_4 	= new C_Splitter ( "IdcSSMSplitter3_4" );

			IdcSSMSplitter1_2.LoadUserCfg ( G_USE_ID );
			IdcSSMSplitter3_4.LoadUserCfg ( G_USE_ID );

			FillCivilityList 	( 'IdcSSMCivility' );
			FillStaffRoleList 	( 'IdcSSMRole' );
			FillLoginRoleList 	( 'IdcSSMLoginRole' );
			FillDepartmentsList	( 'IdcSSMDepartment', -1 );

			FillRISUserList 	( 'IdcSSMRISName' );

			IdcSettingsStaffMemberDT.Create ();
			context.attach ( '#IdcSettingsStaffMemberDT', SettingsStaffMemberDTListMenu );
			IdcSettingsStaffMemberDT.SetRowToSelect ( 'first_row' );

			IdcSettingsStaffMemberJobDT.Create ();
			context.attach ( '#IdcSettingsStaffMemberJobDT', SettingsStaffMemberJobDTListMenu );
			IdcSettingsStaffMemberJobDT.SetRowToSelect ( 'first_row' );

			document.getElementById ( 'IdcSSMImage' ).addEventListener ( 'load', 
				function () 
				{ 
					$('#IdcSSMImage').show ();
                	$('#IdcSSMNoImage').hide (); 
                } );
			document.getElementById ( 'IdcSSMImage' ).addEventListener ( 'error', 
				function () 
				{ 
					$('#IdcSSMImage').hide ();
                	$('#IdcSSMNoImage').show (); 
				} );

			const imageInput = document.getElementById('IdcSSMImageInput');

        	imageInput.addEventListener('change', function(event) {
            const file = event.target.files[0]; // Récupère le premier fichier sélectionné

            if (file) 
            {
                const reader = new FileReader();

                reader.onload = function(e) {
                	$('#IdcSSMImage').attr ( 'src', e.target.result );
             	};

             	reader.readAsDataURL(file);
             	ssmImageFile = file;
            } 
        });


		});
	}

	function SettingsStaffMemberDTGetData ( d )
	{
		return $.extend( {}, d );
	}

	function OnSettingsStaffMemberDTGridProperties ()
	{
		IdcSettingsStaffMemberDT.Properties ();
	}

	function SettingsStaffMemberListDTSelected ( rowsIdx )
	{
		let id 				= -1;
		let civility_id		= -1;
		let lastname		= "";
		let firstname		= "";
		let login			= "";
		let password		= "";
		let email			= "";
		let login_role_id	= -1;
		let active 			= false;
		let ris_name		= "";
		let pacs_name		= "";
		let dacs_name		= "";

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];


			id 				= IdcSettingsStaffMemberDT.GetRowData ( rowIdx ).id;
			civility_id		= IdcSettingsStaffMemberDT.GetRowData ( rowIdx ).civility_id;
			lastname		= IdcSettingsStaffMemberDT.GetRowData ( rowIdx ).lastname;
			firstname		= IdcSettingsStaffMemberDT.GetRowData ( rowIdx ).firstname;
			login			= IdcSettingsStaffMemberDT.GetRowData ( rowIdx ).login;
			password		= IdcSettingsStaffMemberDT.GetRowData ( rowIdx ).password;
			email			= IdcSettingsStaffMemberDT.GetRowData ( rowIdx ).email;
			login_role_id	= IdcSettingsStaffMemberDT.GetRowData ( rowIdx ).login_role_id;
			active			= IdcSettingsStaffMemberDT.GetRowData ( rowIdx ).active;
			ris_name_id		= IdcSettingsStaffMemberDT.GetRowData ( rowIdx ).ris_name;
			pacs_name		= IdcSettingsStaffMemberDT.GetRowData ( rowIdx ).pacs_name;
			dacs_name		= IdcSettingsStaffMemberDT.GetRowData ( rowIdx ).dacs_name;
		} 

		$('#IdcSSMCivility' ).val ( civility_id ).change ();
		$('#IdcSSMLastname' ).val ( lastname );
		$('#IdcSSMFirstname' ).val ( firstname );
		$('#IdcSSMLogin' ).val ( login );
		$('#IdcSSMPassword' ).val ( atob(password) );
		$('#IdcSSMEMail' ).val ( email );
		$('#IdcSSMLoginRole' ).val ( login_role_id ).change ();
		$('#IdcSSMLoginActivated').prop ('checked', (active==0)? false : true ).change();
		$('#IdcSSMInformationsDiv' ).data ('id', id );
		$('#IdcSSMRISName' ).val ( ris_name_id ).change ();
		$('#IdcSSMPACSName' ).val ( pacs_name );
		$('#IdcSSMDACSName' ).val ( dacs_name );

		IdcSettingsStaffMemberJobDT.Refresh ();

		SSMShowStaffMemberImage ();
	}

	function SSMShowStaffMemberImage ()
	{
		let id = $('#IdcSSMInformationsDiv' ).data ('id');
        $('#IdcSSMImage').attr ( 'src', "SubFW/database/staff/get_staff_member_image.php?id=" + id );
	}


	function SettingsStaffMemberJobDTGetData ( d )
	{
		let staffid = $('#IdcSSMInformationsDiv' ).data ('id');

		d.staffid = (staffid == undefined)? -1 : staffid;
		return $.extend( {}, d );
	}

	function OnSettingsStaffMemberJobDTGridProperties ()
	{
		IdcSettingsStaffMemberJobDT.Properties ();
	}

	function SettingsStaffMemberJobListDTSelected ( rowsIdx )
	{
		let id 				= -1;
		let staff_role_id	= -1;
		let dep_id			= -1;
		let begdate			= "";
		let enddate			= "";
		
		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 				= IdcSettingsStaffMemberJobDT.GetRowData ( rowIdx ).id;
			staff_role_id	= IdcSettingsStaffMemberJobDT.GetRowData ( rowIdx ).staff_role_id;
			dep_id			= IdcSettingsStaffMemberJobDT.GetRowData ( rowIdx ).dep_id;
			begdate			= IdcSettingsStaffMemberJobDT.GetRowData ( rowIdx ).begdate;
			enddate			= IdcSettingsStaffMemberJobDT.GetRowData ( rowIdx ).enddate;
		} 

		$('#IdcSSMRole' ).val ( staff_role_id ).change();
		$('#IdcSSMDepartment' ).val ( dep_id ).change();
		$('#IdcSSMFrom' ).val ( DICOMDate2StdDate(begdate) );
		$('#IdcSSMTo' ).val ( DICOMDate2StdDate(enddate) );
		$('#IdcSSMJobInformationsDiv' ).data ('id', id );
	}


	function OnSettingsStaffMemberAddOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsStaffMemberDT.SetRowToSelect ( 'id', response );

			IdcSettingsStaffMemberDT.Refresh ();
		}
		else
			OnSettingsStaffMemberAddError ();
	}

	function OnSettingsStaffMemberAddError ()
	{
		MsgWarning ( Translate("Unable to add staff member !!!") );
	}

	function SettingsStaffMemberAdd ()
	{
		let params = "id=-1";
		params += "&name=New staff member";
		PostASyncData ( "SubFW/database/settings/SaveStaffMember.php", params, 'application/x-www-form-urlencoded', OnSettingsStaffMemberAddOK, OnSettingsStaffMemberAddError );
	}

	function SettingsStaffMemberSave ()
	{
		let id 	= $('#IdcSSMInformationsDiv' ).data ('id');

		let civility_id		= $('#IdcSSMCivility').val ();
		let lastname 		= $('#IdcSSMLastname' ).val ();
		let firstname 		= $('#IdcSSMFirstname' ).val ();
		let login 	 		= $('#IdcSSMLogin' ).val ();
		let password 		= $('#IdcSSMPassword' ).val ();
		let email 			= $('#IdcSSMEMail' ).val ();
		let ris_name_id		= $('#IdcSSMRISName' ).val ();
		let pacs_name 		= $('#IdcSSMPACSName' ).val ();
		let dacs_name 		= $('#IdcSSMDACSName' ).val ();
		let login_role_id	= $('#IdcSSMLoginRole').val ();
		let active			= $('#IdcSSMLoginActivated').prop ('checked');

		const formData = new FormData();
        formData.append ( 'image', 			ssmImageFile 	);
        formData.append ( 'id', 			id 				);
        formData.append ( 'civility_id', 	civility_id 	);
        formData.append ( 'lastname', 		lastname 		);
        formData.append ( 'firstname', 		firstname 		);
        formData.append ( 'login', 			login 			);
        formData.append ( 'password', 		password 		);
        formData.append ( 'email',	 		email 			);
        formData.append ( 'active', 		active 			);
        formData.append ( 'login_role_id', 	login_role_id 	);
        formData.append ( 'ris_name', 		ris_name_id 	);
        formData.append ( 'pacs_name', 		pacs_name 		);
        formData.append ( 'dacs_name', 		dacs_name 		);

		PostASyncData ( "SubFW/database/settings/SaveStaffMember.php", formData, null, OnSettingsStaffMemberAddOK, OnSettingsStaffMemberAddError );		
	}

	function OnDeleteSettingsStaffMemberOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsStaffMemberDT.Refresh ();
			IdcSettingsStaffMemberDT.SetRowToSelect('first_row');
		}
		else
			OnSettingsStaffMemberError ();
	}

	function OnDeleteSettingsStaffMemberError ()
	{
		MsgWarning ( Translate("Unable to delete staff member !!!") );
	}

	function DeleteSettingsStaffMember ()
	{
		let selRows = IdcSettingsStaffMemberDT.GetSelectedRows ();
		if ( selRows.length == 1 )
		{
			let id = IdcSettingsStaffMemberDT.GetRowData ( selRows [0] ).id;

			PostASyncData ( "SubFW/database/settings/DeleteStaffMember.php", "id="+id, 'application/x-www-form-urlencoded', OnDeleteSettingsStaffMemberOK, OnDeleteSettingsStaffMemberError );
		}
	}

	function SettingsStaffMemberDelete ()
	{
		let selRows = IdcSettingsStaffMemberDT.GetSelectedRows ();
		if ( selRows.length == 1 )
			MsgYesNo ( Translate("Delete selected staff member ?"), DeleteSettingsStaffMember );
		else
			MsgWarning ( Translate("No staff member selected !!!") );
	}

	function SSMLoginActivatedClicked ()
	{
		let active = $('#IdcSSMLoginActivated').prop ('checked');
	}





	function OnSettingsStaffMemberJobAddOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsStaffMemberJobDT.SetRowToSelect ( 'id', response );

			IdcSettingsStaffMemberJobDT.Refresh ();
		}
		else
			OnSettingsStaffMemberJobAddError ();
	}

	function OnSettingsStaffMemberJobAddError ()
	{
		MsgWarning ( Translate("Unable to add job !!!") );
	}

	function SettingsStaffMemberJobAdd ()
	{
		let staff_id 	= $('#IdcSSMInformationsDiv' ).data ('id');

		let params = "id=-1";
		params += "&staff_id=" + staff_id;
		
		PostASyncData ( "SubFW/database/settings/SaveStaffMemberJob.php", params, 'application/x-www-form-urlencoded', OnSettingsStaffMemberJobAddOK, OnSettingsStaffMemberJobAddError );
	}

	function SettingsStaffMemberJobSave ()
	{
		let id 				= $('#IdcSSMJobInformationsDiv' ).data ('id');
		let staff_id 		= $('#IdcSSMInformationsDiv' ).data ('id');
		let dep_id 	 		= $('#IdcSSMDepartment' ).val ();
		let staff_role_id	= $('#IdcSSMRole' ).val ();
		let begdate			= $('#IdcSSMFrom' ).val ();
		let enddate			= $('#IdcSSMTo' ).val ();
		

		let params = "id=" + id;
		params += "&staff_id=" + staff_id;
		params += "&dep_id=" + dep_id;
		params += "&staff_role_id=" + staff_role_id;
		params += "&begdate=" + begdate;
		params += "&enddate=" + enddate;

		PostASyncData ( "SubFW/database/settings/SaveStaffMemberJob.php", params, 'application/x-www-form-urlencoded', OnSettingsStaffMemberJobAddOK, OnSettingsStaffMemberJobAddError );
	}

	function OnDeleteSettingsStaffMemberJobOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsStaffMemberJobDT.Refresh ();
			IdcSettingsStaffMemberJobDT.SetRowToSelect('first_row');
		}
		else
			OnSettingsStaffMemberJobError ();
	}

	function OnDeleteSettingsStaffMemberJobError ()
	{
		MsgWarning ( Translate("Unable to delete job !!!") );
	}

	function DeleteSettingsStaffMemberJob ()
	{
		let selRows = IdcSettingsStaffMemberJobDT.GetSelectedRows ();
		if ( selRows.length == 1 )
		{
			let id = IdcSettingsStaffMemberJobDT.GetRowData ( selRows [0] ).id;

			PostASyncData ( "SubFW/database/settings/DeleteStaffMemberJob.php", "id="+id, 'application/x-www-form-urlencoded', OnDeleteSettingsStaffMemberJobOK, OnDeleteSettingsStaffMemberJobError );
		}
	}

	function SettingsStaffMemberJobDelete ()
	{
		let selRows = IdcSettingsStaffMemberJobDT.GetSelectedRows ();
		if ( selRows.length == 1 )
			MsgYesNo ( Translate("Delete selected job ?"), DeleteSettingsStaffMemberJob );
		else
			MsgWarning ( Translate("No job selected !!!") );
	}


	function OnSettingsStaffMemberPhotoAlbum ()
	{
		console.log ( "OnSettingsStaffMemberPhotoAlbum..." );

		PhotoAlbumShow ();
	}