	SettingsTagDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSettingsTagDT.Properties () }
		}
	];

	function InitSettingsTagPage ()
	{
		let ss = sessionStorage.getItem ( 'SettingsTagPageInitialized' );

		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsTagPageInitialized', true );

		IdcSettingsTagDT = new C_DataTable ();
		IdcSettingsTagDT.DataSrcType		= 0;
		IdcSettingsTagDT.Ident 			= 'IdcSettingsTagDT';
		IdcSettingsTagDT.Container 		= 'IdcSTDTContainer';
		IdcSettingsTagDT.DataSrc 		= 'SubFW/database/settings/GetDTTag.php';
		IdcSettingsTagDT.DataFct		= SettingsTagDTGetData;
		IdcSettingsTagDT.SetColReorder 	( false );
		IdcSettingsTagDT.OnSelect		( SettingsTagListDTSelected );
		IdcSettingsTagDT.AddColumn 		( 'id',					'id',	 				0, false,  0,  50, 		false, '', 	'' );
		IdcSettingsTagDT.AddColumn 		( Translate('Name'),	'name',		 			1, true,   1, '100%', 	true,  '', 	'' );
		IdcSettingsTagDT.LoadUserCfg 	( G_USE_ID );


		$(document).ready(function () 
		{
			IdcSTSplitter1_2 	= new C_Splitter ( "IdcSTSplitter1_2" )
			IdcSTSplitter1_2.LoadUserCfg ( G_USE_ID );;

			IdcSettingsTagDT.Create ();
			context.attach ( '#IdcSettingsTagDT', SettingsTagDTListMenu );

			IdcSettingsTagDT.SetRowToSelect('first_row');
		});
	}

	function SettingsTagDTGetData ( d )
	{
		// d.pat_id = ( this.RFPatID == -1 )? -2 : this.RFPatID;
		
		return $.extend( {}, d );
	}

	
	function SettingsTagListDTSelected ( rowsIdx )
	{
		let id 				= -1;
		let name 			= "";

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 			= IdcSettingsTagDT.GetRowData ( rowIdx ).id;
			name 		= IdcSettingsTagDT.GetRowData ( rowIdx ).name;
		}

		$('#IdcSTName' ).val ( name );

		$('#IdcSTInformationsDiv' ).data ('id', id );
	}

	function OnSettingsTagAddOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsTagDT.SetRowToSelect ( 'id', response );

			IdcSettingsTagDT.Refresh ();
		}
		else
			OnSaveDeviceInstallationError ();
	}

	function OnSettingsTagAddError ()
	{
		MsgWarning ( Translate("Unable to add tag !!!") );
	}

	function SettingsTagAdd ()
	{
		let id 	= -1;

		let params = "id=" + id;
		params += "&name=New tag";
		PostASyncData ( "SubFW/database/settings/SaveTag.php", params, 'application/x-www-form-urlencoded', OnSettingsTagAddOK, OnSettingsTagAddError );
	}

	function SettingsTagSave ()
	{
		let id 	= $('#IdcSTInformationsDiv' ).data ('id');

		let name 	= $('#IdcSTName' ).val ();
		
		let params = "id=" + id;
		params += "&name=" + name;

		PostASyncData ( "SubFW/database/settings/SaveTag.php", params, 'application/x-www-form-urlencoded', OnSettingsTagAddOK, OnSettingsTagAddError );
	}

	function OnDeleteSettingsTagOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsTagDT.Refresh ();
			IdcSettingsTagDT.SetRowToSelect('first_row');
		}
		else
			OnSettingsTagError ();
	}

	function OnDeleteSettingsTagError ()
	{
		MsgWarning ( Translate("Unable to delete tag !!!") );
	}

	function DeleteSettingsTag ()
	{
		let selRows = IdcSettingsTagDT.GetSelectedRows ();
		if ( selRows.length == 1 )
		{
			let id = IdcSettingsTagDT.GetRowData ( selRows [0] ).id;

			PostASyncData ( "SubFW/database/settings/DeleteTag.php", "id="+id, 'application/x-www-form-urlencoded', OnDeleteSettingsTagOK, OnDeleteSettingsTagError );
		}
	}

	function SettingsTagDelete ()
	{
		let selRows = IdcSettingsTagDT.GetSelectedRows ();
		if ( selRows.length == 1 )
			MsgYesNo ( Translate("Delete selected tag ?"), DeleteSettingsTag );
		else
			MsgWarning ( Translate("No tag selected !!!") );
	}