	SettingsWarningDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { OnSettingsWarningDTGridProperties() }
		}
	];

	function InitSettingsWarningPage ()
	{
		let ss = sessionStorage.getItem ( 'SettingsWarningPageInitialized' );

		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsWarningPageInitialized', true );

		IdcSettingsWarningDT = new C_DataTable ();
		IdcSettingsWarningDT.DataSrcType	= 0;
		IdcSettingsWarningDT.Ident 			= 'IdcSettingsWarningDT';
		IdcSettingsWarningDT.Container 		= 'IdcSWDTContainer';
		IdcSettingsWarningDT.DataSrc 		= 'SubFW/database/settings/GetDTWarning.php';
		IdcSettingsWarningDT.DataFct		= SettingsWarningDTGetData;
		IdcSettingsWarningDT.SetColReorder 	( false );
		IdcSettingsWarningDT.OnSelect		( SettingsWarningListDTSelected );
		IdcSettingsWarningDT.AddColumn 		( 'id',						'id',	 				0, false,  0,  50, 		false, '', 	'' );
		IdcSettingsWarningDT.AddColumn 		( 'sex_id',					'sex_id', 				0, false,  1,  50, 		false, '', 	'' );
		IdcSettingsWarningDT.AddColumn 		( 'age_id',					'age_id', 				0, false,  2,  50, 		false, '', 	'' );
		IdcSettingsWarningDT.AddColumn 		( Translate('Title'),		'title',	 			1, true,   3, '40%', 	true,  '', 	'' );
		IdcSettingsWarningDT.AddColumn 		( Translate('Description'),	'description',	 		1, true,   4, '60%', 	true,  '', 	'' );
		IdcSettingsWarningDT.LoadUserCfg 	( G_USE_ID );


		$(document).ready(function () 
		{
			IdcSWSplitter1_2 	= new C_Splitter ( "IdcSWSplitter1_2" );
			IdcSWSplitter1_2.LoadUserCfg ( G_USE_ID );;

			IdcSettingsWarningDT.Create ();
			context.attach ( '#IdcSettingsWarningDT', SettingsWarningDTListMenu );
			IdcSettingsWarningDT.SetRowToSelect ( 'first_row' );

			FillSexList ( 'IdcSWSexID');
			FillAgeList ( 'IdcSWAgeID');
		});
	}

	function SettingsWarningDTGetData ( d )
	{
		return $.extend( {}, d );
	}

	function OnSettingsWarningDTGridProperties ()
	{
		IdcSettingsWarningDT.Properties ();
	}

	function SettingsWarningListDTSelected ( rowsIdx )
	{
		let id 				= -1;
		let title 			= "";
		let description		= "";
		let sex_id			= -1;
		let age_id			= -1;

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 				= IdcSettingsWarningDT.GetRowData ( rowIdx ).id;
			title 			= IdcSettingsWarningDT.GetRowData ( rowIdx ).title;
			description 	= IdcSettingsWarningDT.GetRowData ( rowIdx ).description;
			sex_id 			= IdcSettingsWarningDT.GetRowData ( rowIdx ).sex_id;
			age_id 			= IdcSettingsWarningDT.GetRowData ( rowIdx ).age_id;
		}

		$('#IdcSWTitle' ).val ( title );
		$('#IdcSWDescription' ).val ( description );
		$('#IdcSWSexID' ).val ( sex_id ).change ();
		$('#IdcSWAgeID' ).val ( age_id ).change ();

		$('#IdcSWInformationsDiv' ).data ('id', id );
	}

	function OnSettingsWarningAddOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsWarningDT.SetRowToSelect ( 'id', response );

			IdcSettingsWarningDT.Refresh ();
		}
		else
			OnSettingsWarningAddError ();
	}

	function OnSettingsWarningAddError ()
	{
		MsgWarning ( Translate("Unable to add warning !!!") );
	}

	function SettingsWarningAdd ()
	{
		let params = "id=-1&title=New Warning";
		PostASyncData ( "SubFW/database/settings/SaveWarning.php", params, 'application/x-www-form-urlencoded', OnSettingsWarningAddOK, OnSettingsWarningAddError );
	}

	function SettingsWarningSave ()
	{
		let id 	= $('#IdcSWInformationsDiv' ).data ('id');

		let title 			= $('#IdcSWTitle' ).val ();
		let description 	= $('#IdcSWDescription' ).val ();
		let sex_id 			= $('#IdcSWSexID' ).val ();
		let age_id 			= $('#IdcSWAgeID' ).val ();
		
		let params = "id=" + id;
		params += "&title=" + title;
		params += "&description=" + description;
		params += "&sex_id=" + sex_id;
		params += "&age_id=" + age_id;

		PostASyncData ( "SubFW/database/settings/SaveWarning.php", params, 'application/x-www-form-urlencoded', OnSettingsWarningAddOK, OnSettingsWarningAddError );
	}

	function OnDeleteSettingsWarningOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsWarningDT.Refresh ();
			IdcSettingsWarningDT.SetRowToSelect('first_row');
		}
		else
			OnSettingsWarningError ();
	}

	function OnDeleteSettingsWarningError ()
	{
		MsgWarning ( Translate("Unable to delete warning !!!") );
	}

	function DeleteSettingsWarning ()
	{
		let selRows = IdcSettingsWarningDT.GetSelectedRows ();
		if ( selRows.length == 1 )
		{
			let id = IdcSettingsWarningDT.GetRowData ( selRows [0] ).id;

			PostASyncData ( "SubFW/database/settings/DeleteWarning.php", "id="+id, 'application/x-www-form-urlencoded', OnDeleteSettingsWarningOK, OnDeleteSettingsWarningError );
		}
	}

	function SettingsWarningDelete ()
	{
		let selRows = IdcSettingsWarningDT.GetSelectedRows ();
		if ( selRows.length == 1 )
			MsgYesNo ( Translate("Delete selected warning ?"), DeleteSettingsWarning );
		else
			MsgWarning ( Translate("No warning selected !!!") );
	}