	
	function InitStaffPage ()
	{
		let ss = sessionStorage.getItem ( 'StaffPageInitialized' );

		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'StaffPageInitialized', true );

		StaffListDTMenu = [
    		{
        		header: ''
    		},

			{
        		img: G_ServerFolder+'/eoQUAL/SubFW/bmp/setup_1_blue.png',
        		text: 'Grid properties...',
        		action: function(e, selector) { IdcStaffListDT.Properties (); }
    		}
		];

		StaffFormationListDTMenu = [
    		{
        		header: ''
    		},

			{
        		img: G_ServerFolder+'/eoQUAL/SubFW/bmp/setup_1_blue.png',
        		text: 'Grid properties...',
        		action: function(e, selector) { IdcStaffFormationListDT.Properties (); }
    		}
		];

		IdcStaffListDT = new C_DataTable ();
		IdcStaffListDT.DataSrcType		= 0;
		IdcStaffListDT.Ident 			= 'IdcStaffListDT';
		IdcStaffListDT.Container 		= 'IdcStaffListDTContainer';
		IdcStaffListDT.DataSrc 			= G_ServerFolder+'/eoQUAL/SubFW/database/staff/GetStaffList.php';
		IdcStaffListDT.DataFct			= StaffListDTGetData;
		IdcStaffListDT.SetColReorder 	( true );
		IdcStaffListDT.OnSelectChanged	( StaffListDTSelectChanged );
				
		IdcStaffListDT.AddColumn ( 'id',				'id',	 				1, false,  0,    50, false, '', 	'' );
		IdcStaffListDT.AddColumn ( Translate('Name'),	'fullname',	 			1, true,   1, '40%', true,  '', 	'' );
		IdcStaffListDT.AddColumn ( Translate('Job'),	'job', 					1, true,   2, '60%', true,  '', 	'' );
		IdcStaffListDT.SetColumnFilter (  'fullname', 	'<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcStaffListNameFilter" class="form-control pt-0 pb-0" oninput="IdcStaffListDT.Refresh()" type="text" placeholder="'+Translate("Name")+'"></div>' );
		IdcStaffListDT.SetColumnFilter (  'job', 		'<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcStaffListJobFilter" class="form-control pt-0 pb-0" oninput="IdcStaffListDT.Refresh()" type="text" placeholder="'+Translate("Job")+'"></div>' );
				
		IdcStaffListDT.LoadUserCfg ( G_USE_ID );



		IdcStaffInfoDocListDT			= new C_DocumentDT ( "IdcStaffInfoDocListDT" );
		IdcStaffInfoDocListDT.Caption  	= 'Document';
		IdcStaffInfoDocListDT.DocType	= "staff_member";
		IdcStaffInfoDocListDT.ExtType	= "staff_member";
		IdcStaffInfoDocListDT.Container	= 'IdcStaffInfoDocListDTContainer';
		IdcStaffInfoDocListDT.Editor	= StaffEdition;
		IdcStaffInfoDocListDT.LoadUserCfg ( G_USE_ID );


		
		IdcStaffFormationListDT = new C_DataTable ();
		IdcStaffFormationListDT.DataSrcType		= 0;
		IdcStaffFormationListDT.Ident 			= 'IdcStaffFormationListDT';
		IdcStaffFormationListDT.Container 		= 'IdcStaffFormationListDTContainer';
		IdcStaffFormationListDT.DataSrc 		= G_ServerFolder+'/eoQUAL/SubFW/database/staff/GetFormationsList.php';
		IdcStaffFormationListDT.DataFct			= StaffFormationListDTGetData;
		IdcStaffFormationListDT.SetColReorder 	( true );
		IdcStaffFormationListDT.OnSelectChanged	( StaffFormationListDTSelectChanged ); 
				
		IdcStaffFormationListDT.AddColumn ( 'id',						'id',	 				0, false,  0,   50, false, '', 				'' );
		IdcStaffFormationListDT.AddColumn ( 'StatusID',					'status_id', 			0, false,  1,   50, false, '', 				'' );
		IdcStaffFormationListDT.AddColumn ( Translate('Status'),		'status_name', 			1, true,   2, '15%', true,  '', 			'',	Translate );
		IdcStaffFormationListDT.AddColumn ( Translate('Planned-f'),		'planned_date',	 		1, true,   3, '15%', true,  'text-center', 	'', DICOMDate2StdDateFR );
		IdcStaffFormationListDT.AddColumn ( Translate('Performed-f'),	'formation_date',		1, true,   4, '15%', true,  'text-center', 	'', DICOMDate2StdDateFR );
		IdcStaffFormationListDT.AddColumn ( Translate('Title'),			'title',	 			1, true,   5, '15%', true,  '', 				'' );
		IdcStaffFormationListDT.AddColumn ( Translate('Type'),			'type',		 			1, true,   6, '15%', true,  '', 				'' );
		IdcStaffFormationListDT.AddColumn ( Translate('Comment'),		'comment',	 			1, true,   7, '25%', true,  '', 				'' );
		
		IdcStaffFormationListDT.LoadUserCfg ( G_USE_ID );
		

		IdcStaffFormationDocListDT				= new C_DocumentDT ( "IdcStaffFormationDocListDT" );
		IdcStaffFormationDocListDT.Caption  	= 'Document';
		IdcStaffFormationDocListDT.DocType		= "staff_formation";
		IdcStaffFormationDocListDT.ExtType		= "staff_formation";
		IdcStaffFormationDocListDT.Container	= 'IdcStaffFormationDocListDTContainer';
		IdcStaffFormationDocListDT.Editor		= StaffEdition;
		IdcStaffFormationDocListDT.LoadUserCfg ( G_USE_ID );

		$(document).ready(function () 
		{
			IdcStaffSplitter1_2 	= new C_Splitter ( "IdcStaffSplitter1_2" );
			IdcStaffSplitter3_4 	= new C_Splitter ( "IdcStaffSplitter3_4" );
			IdcStaffSplitter5_6 	= new C_Splitter ( "IdcStaffSplitter5_6" );

			IdcStaffSplitter1_2.LoadUserCfg ( G_USE_ID );
			IdcStaffSplitter3_4.LoadUserCfg ( G_USE_ID );
			IdcStaffSplitter5_6.LoadUserCfg ( G_USE_ID );

			
			IdcStaffListDT.Create ();
			IdcStaffListDT.SetRowToSelect('first_row');
			context.attach ( '#IdcStaffListDT', 	StaffListDTMenu 	);

			IdcStaffInfoDocListDT.Create ();


			IdcStaffFormationListDT.Create ();
			IdcStaffFormationListDT.SetRowToSelect('first_row');
			context.attach ( '#IdcStaffFormationListDT', 	StaffFormationListDTMenu 	);

			IdcStaffFormationDocListDT.Create ( 1 );

			document.getElementById ( 'IdcStaffImage' ).addEventListener ( 'load', 
				function () 
				{ 
					$('#IdcStaffImage').show ();
                	$('#IdcStaffNoImage').hide (); 
                } );
			document.getElementById ( 'IdcStaffImage' ).addEventListener ( 'error', 
				function () 
				{ 
					$('#IdcStaffImage').hide ();
                	$('#IdcStaffNoImage').show (); 
				} );

			window.addEventListener ( "message", function(event) {
    			if (event.data.action === "CloseOOEditor") 
    			{
      				const iframe = document.getElementById("IdcStaffEditorFrame");
      				if (iframe) 
      				{
        				iframe.style.display = "none"; // ou iframe.remove();
        				$("#IdcStaffSplitter1_2").show ();
      				}
    			}
  			});

			switchLanguage ( CurrentLanguage );
		});
	}

	function StaffEdition ( doc_id )
	{
		$("#IdcStaffSplitter1_2").hide ();
		$("#IdcStaffEditorFrame").show ();

		$('#IdcStaffEditorFrame').attr ( 'src', 'SubFW/html/OnlyOfficeEditor.php?doc_id='+doc_id );
	}

	function StaffListDTGetData ( d ) 
	{
		d.hasactivejob 		= document.getElementById ( 'IdcStaffActiveJob' ).checked;
		d.name 				= $('#IdcStaffListNameFilter').val ();
		d.job 				= $('#IdcStaffListJobFilter').val ();

		return $.extend( {}, d );
	}


	function StaffFormationListDTGetData ( d ) 
	{
		d.staffid			= $('#IdcStaffFormationPanel' ).data ('staff_id');
		
		return $.extend( {}, d );
	}

	function StaffActiveJobClicked ()
	{
		IdcStaffListDT.Refresh ();
	}


	function StaffListDTSelectChanged ( rowsIdx )
	{
		let id 			= -1;
		let name 		= "";
		let job 		= "";

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];
			
			id 			= IdcStaffListDT.GetRowData ( rowIdx ).id;
			name 		= IdcStaffListDT.GetRowData ( rowIdx ).fullname;
			job 		= IdcStaffListDT.GetRowData ( rowIdx ).job;
		}
		
		$('#IdcStaffInfoName' ).val ( name );
		$('#IdcStaffInfoJob' ).val ( job );


		$('#IdcStaffInformationPanel' 	).data ('staff_id', id );
		$('#IdcStaffFormationPanel' 	).data ('staff_id', id );

		IdcStaffInfoDocListDT.ExtID = id;
		IdcStaffInfoDocListDT.Refresh ();
		
		IdcStaffFormationListDT.Refresh ();

		StaffShowMemberImage ();
	}

	function StaffShowMemberImage ()
	{
		let id = $('#IdcStaffInformationPanel' 	).data ('staff_id');
        $('#IdcStaffImage').attr ( 'src', "SubFW/database/staff/get_staff_member_image.php?id=" + id );
	}


	function StaffFormationListDTSelectChanged ( rowsIdx )
	{
		let id 				= -1;
		let title			= "";
		let type 			= "";
		let planned_date	= "";
		let formation_date	= "";
		let comment 		= "";
		let status_id		= -1;

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];
		
			id 	 			= IdcStaffFormationListDT.GetRowData ( rowIdx ).id;
			title 			= IdcStaffFormationListDT.GetRowData ( rowIdx ).title;
			type  			= IdcStaffFormationListDT.GetRowData ( rowIdx ).type;
			planned_date 	= IdcStaffFormationListDT.GetRowData ( rowIdx ).planned_date;
			formation_date	= IdcStaffFormationListDT.GetRowData ( rowIdx ).formation_date;
			comment			= IdcStaffFormationListDT.GetRowData ( rowIdx ).comment;
			status_id		= IdcStaffFormationListDT.GetRowData ( rowIdx ).status_id;
		}

		$('#IdcStaffFormationTitle').val 		( title );
		$('#IdcStaffFormationType').val 		( type );
		$('#IdcStaffFormationPlanned').val 		( DICOMDate2StdDate(planned_date) );
		$('#IdcStaffFormationPerformed').val 	( DICOMDate2StdDate(formation_date) );
		$('#IdcStaffFormationComment').val 		( comment );
		$('#IdcStaffFormationStatus').val 		( status_id ).change();

		$('#IdcStaffFormationPanel' ).data ('formation_id', id );

		IdcStaffFormationDocListDT.ExtID = id;
		IdcStaffFormationDocListDT.Refresh ();
	}

	


	// =============================================================================
	// Save staff Formation
	//

	function OnSaveStaffFormationOK ( response )
	{
		if ( response != '-1')
			IdcStaffFormationListDT.Refresh ();
		else
			OnSaveStaffFormationError ();
	}

	function OnSaveStaffFormationError ()
	{
		MsgWarning ( Translate("Unable to save staff formation !!!") );
	}

	function StaffFormationSave ()
	{
		let formation_id 	= $('#IdcStaffFormationPanel' ).data ('formation_id');
		let title 			= $('#IdcStaffFormationTitle').val ();
		let type 			= $('#IdcStaffFormationType').val ();
		let planned_date	= $('#IdcStaffFormationPlanned').val ();
		let formation_date	= $('#IdcStaffFormationPerformed').val ();
		let comment			= $('#IdcStaffFormationComment').val ();
		let status_id 		= $('#IdcStaffFormationStatus').val ();

		let params = "id=" + formation_id;
		params += "&title=" + title;
		params += "&type=" + type;
		params += "&planned_date=" + planned_date;
		params += "&formation_date=" + formation_date;
		params += "&comment=" + comment;
		params += "&status_id=" + status_id;
		PostASyncData ( "SubFW/database/staff/SaveStaffFormation.php", params, 'application/x-www-form-urlencoded', OnSaveStaffFormationOK, OnSaveStaffFormationError );
	}

	function StaffFormationAdd ()
	{
		console.log ( "StaffFormationAdd...");
		let staff_id = $('#IdcStaffInformationPanel' 	).data ('staff_id' );

		let params = "id=-1&staff_id=" + staff_id;
		PostASyncData ( "SubFW/database/staff/SaveStaffFormation.php", params, 'application/x-www-form-urlencoded', OnSaveStaffFormationOK, OnSaveStaffFormationError );
	}


	function OnDeleteStaffFormationOK ( response )
	{
		if ( response != '-1')
			IdcStaffFormationListDT.Refresh ();
		else
			OnDeleteStaffFormationError ();
	}

	function OnDeleteStaffFormationError ()
	{
		MsgWarning ( Translate("Unable to delete staff formation !!!") );
	}

	function StaffFormationDelete ()
	{
		MsgYesNo ( Translate("Delete selected formation ?"), DeleteStaffFormation );
	}

	function DeleteStaffFormation ()
	{
		console.log ( "DeleteStaffFormation...");
		let formation_id = $('#IdcStaffFormationPanel' ).data ('formation_id' );

		let params = "id=" + formation_id;
		PostASyncData ( "SubFW/database/staff/DeleteStaffFormation.php", params, 'application/x-www-form-urlencoded', OnDeleteStaffFormationOK, OnDeleteStaffFormationError );
	}