	
	var chartConfigByID = Array();
		
	var chartSelectedByLayout = Array();

	function InitStatisticPage ()
	{
		let ss = sessionStorage.getItem ( 'StatisticPageInitialized' );

		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'StatisticPageInitialized', true );

		$(document).ready(function () 
		{
			$( "#IdcStatisticFromDate" ).val ( GetCurrentDate());
			$( "#IdcStatisticToDate" ).val ( GetCurrentDate());

			
			IdcStatisticRadiologistsCBMenu = new C_CheckboxMenu ( "IdcStatisticRadiologistsContainer", "IdcStatisticRadiologistsCBMenu", Translate("Click here to select radiologists") );
			IdcStatisticRadiologistsCBMenu.CallbackFct = StatisticRadiologistsChanged;

			IdcStatisticModalitiesCBMenu = new C_CheckboxMenu ( "IdcStatisticModalitiesContainer", "IdcStatisticModalitiesCBMenu", Translate("Click here to select modalities") );
			IdcStatisticModalitiesCBMenu.CallbackFct = StatisticModalitiesChanged;

			StatisticInitRadiologistsList 	( IdcStatisticRadiologistsCBMenu	);
			StatisticInitModalitiesList 	( IdcStatisticModalitiesCBMenu		);

			$('#IdcStatisticLayout_2X2').prop ( 'checked', true );
			StatisticLayoutChanged();
		}); 
	}

	function StatisticRadiologistsChanged ()
	{
		let selectedElements = IdcStatisticRadiologistsCBMenu.GetSelection ();
	}

	function StatisticInitRadiologistsList ( cbElem )
	{
		let lastSeparator = "";
		
		var xhra= getxhr();
			
		xhra.onloadend = function f()
		{
			if ( xhra.readyState == 4 && xhra.status == 200 )  
			{
				let reponse			= clean(xhra.responseXML.documentElement);
				let radiologists	= reponse.getElementsByTagName ( 'radiologist' );
				
				for ( let i=0; i<radiologists.length; i++ )
				{
					let id			= radiologists.item (i).getAttribute ( "id" 		);
					let fullname	= radiologists.item (i).getAttribute ( "fullname" 	);
																	
					cbElem.AddItem ( -1, id, fullname );
				}
			}
		};

		let url = "SubFW/database/common/get_radiologists.php";
		xhra.open ('GET', url, false );
		xhra.send ();
	}

	function StatisticInitModalitiesList ( cbElem )
	{
		let lastSeparator = "";
		
		var xhra= getxhr();
			
		xhra.onloadend = function f()
		{
			if ( xhra.readyState == 4 && xhra.status == 200 )  
			{
				let reponse			= clean(xhra.responseXML.documentElement);
				let modalities	 	= reponse.getElementsByTagName ( 'modality' );
				
				lastSeparator = "";

				for ( let i=0; i<modalities.length; i++ )
				{
					let type			= modalities.item (i).getAttribute ( "type" );
					let id 				= modalities.item (i).getAttribute ( "id" 	);
					let name			= modalities.item (i).getAttribute ( "name" );
											
					if ( lastSeparator != type )
					{
						cbElem.AddTextSeparator ( type );
						lastSeparator = type;
					}
					
					cbElem.AddItem ( type, id, name );
				}
			}
		};

		let url = "SubFW/database/common/get_modalities.php";
		xhra.open ('GET', url, false );
		xhra.send ();
	}

	function StatisticModalitiesChanged ()
	{
		let selectedElements = IdcStatisticModalitiesCBMenu.GetSelection ();
	}

	function OnStatisticApply ()
	{
	}

	function setLayout ( lidselected )
	{
  		llayout2refresh = [];
  		var node = document.getElementById('IdcStatisticLayoutContainer');
  		node.innerHTML = '';
  		var cols = 2;
  		var rows = 2;
  		var col_to_change = 0;
  		switch(lidselected)
  		{
    		case 'l1x1': cols = 1; rows = 1;break;
    		case 'l2x1': cols = 1; rows = 2;break;
    		case 'l1_1x2': cols = 1; rows = 2;col_to_change = 1;break;
    		case 'l1x2': cols = 2; rows = 1;break;
    		case 'l2x2': cols = 2; rows = 2;break;
  		}

  		var rowheight = 100/rows;
  		var rowstringtotal= '';
  		for(var y = 0; y < rows; y++)
  		{
  			let pt = ( y==0 )? 'pt-0': 'pt-2';
  			let pb = ( y==0 )? 'pb-0': '';

    		//var divrow = document.createElement('div');
    		var rowstring = '<div class="row row-cols-'+cols+' ' + pb + ' ' +pt+'" style="min-height:'+rowheight+'%;height:'+rowheight+'%">';
    		for(var x = 0; x < cols; x++)
    		{
      			var id = x+'_'+y;
      			llayout2refresh.push(id);
      			var lid = 'layoutid'+id;
      			var selectedstyleid = 'selectedstyleid'+id;
      			var selectedcharttypeid = 'selectedchartypeid'+id;
      			var styleid = 'styleid'+id;
      			var chartid = 'chartid'+id;

      			var canvasid = 'canvasid'+id;
      			var activechartidtype = null;
      			var activechartstyle = null;

      			let ps = (x==0)? 'ps-2' : ''; 
      			let pe = (x==0 || x==(cols-1))? 'pe-2' : '';



      			if(chartSelectedByLayout[id] !== undefined)
      			{
        			activechartidtype = chartSelectedByLayout[id].idtype;
        			activechartstyle = chartSelectedByLayout[id].style;
      			}

      			rowstring += '<div id="'+lid+'" class="col m-0 p-0 h-100 '+ps+" " + pe +'">';
      			rowstring += '  <div class="card mb-3 h-100">';
      			rowstring += '    <div class="card-header">';
      			rowstring += '        <div class="row">';
      			rowstring += '          <div class="dropdown" style="display:inline-block;">';
				rowstring += '				     <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="IdcStyleMenuButton0" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="color: #000000; background-color: #f7f7f7; border-color: #f7f7f7;">';
				rowstring += '     	         <i id="'+selectedstyleid+'" class="'+getIconChartStyle(activechartstyle)+'"></i>';
				rowstring += '				     </button>';
				rowstring += '				     <div class="dropdown-menu" id="'+styleid+'" aria-labelledby="IdcStyleMenuButton0" x-placement="bottom-start" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(0px, 31px, 0px);">';
      			rowstring += getChartStyleList(id,activechartidtype);
      			rowstring += '			       </div>';
      			rowstring += '             <div class="dropdown" style="display:inline-block;">';
      			rowstring += '                <button id="'+selectedcharttypeid+'" class="btn btn-secondary btn-sm dropdown-toggle" type="button"  data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="color: #000000; background-color: #f7f7f7; border-color: #f7f7f7;">';
      			rowstring += (activechartidtype == null)? 'Chart type' : chartConfigByID[activechartidtype].label;
      			rowstring += '                </button>';
      			rowstring += '                <div class="dropdown-menu" aria-labelledby="IdcMenuButton3" id="IdcDivMenuArea3">';
      			rowstring += getChartTypeList(id);
      			rowstring += '                </div>';
      			rowstring += '             </div>';
      			rowstring += '          </div>';
      			rowstring += '      </div>';
      			rowstring += '    </div>';
      			rowstring += '    <div id="chart-container" style="width: 100%;max-height: 100% !important; height: 100%;">';
      			rowstring += '      <canvas id="'+canvasid+'" "></canvas>';
      			rowstring += '    </div>';
      			rowstring += '  </div>';
      			//end of col;
      			rowstring +='</div>';
    		}
    		rowstring += '</div>';
    		cols += col_to_change;
    		col_to_change = 0;
    		rowstringtotal += rowstring;
  		}
  		node.innerHTML = rowstringtotal;

  		llayout2refresh.forEach(lid => {
    		var layoutselected = chartSelectedByLayout[lid];
    		if(layoutselected !== undefined && (layoutselected.chartobj != null || layoutselected.default !== undefined))
      			refreshData(lid);
    		}
  		);
	}


	function getChartStyleList(id, idtype)
	{
  		if(idtype == null && chartSelectedByLayout[id] === undefined)
  		{
    		if(chartSelectedByLayout[id] === undefined)
    		{
      			return '';
    		}

    		idtype = chartSelectedByLayout[id].idtype;
  		}

  		chartConfig = chartConfigByID[idtype];
  		var chartypelist = '';

  		if(chartConfig.style.bar)
   			chartypelist += '<a class="dropdown-item" name="bar" onclick="event.stopPropagation();window.selectActiveStyle(\''+id+'\',this.name);window.changeChartStyle(\''+id+'\');">Bar</a>';

  		if(chartConfig.style.barstacked)
    		chartypelist += '<a class="dropdown-item" name="barstacked" onclick="event.stopPropagation();window.selectActiveStyle(\''+id+'\',this.name);window.changeChartStyle(\''+id+'\');">Bar stacked</a>';

  		if(chartConfig.style.pie)
    		chartypelist += '<a class="dropdown-item" name="pie" onclick="event.stopPropagation();window.selectActiveStyle(\''+id+'\',this.name);window.changeChartStyle(\''+id+'\');">Pie</a>';

  		if(chartConfig.style.line)
    		chartypelist += '<a class="dropdown-item" name="line" onclick="event.stopPropagation();window.selectActiveStyle(\''+id+'\',this.name);window.changeChartStyle(\''+id+'\');">Line</a>';

  		if(chartConfig.style.linestacked)
   			chartypelist += '<a class="dropdown-item" name="linestacked" onclick="event.stopPropagation();window.selectActiveStyle(\''+id+'\',this.name);window.changeChartStyle(\''+id+'\');">Line stacked</a>';

  		if(chartypelist == '')
    		chartypelist = '<a class="dropdown-item" name="none" onclick="event.stopPropagation();window.selectActiveStyle(\''+id+'\',this.name)>No style defined</a>';

  		return chartypelist;
		//  return '<a class="dropdown-item" id="Graph0_ico_0">Bar</a><a class="dropdown-item" id="Graph0_ico_1">Bar stacked</a><a class="dropdown-item" id="Graph0_ico_2">Pie</a><a class="dropdown-item" id="Graph0_ico_3">Line</a><a class="dropdown-item" id="Graph0_ico_4">Line stacked</a>';
	}

	function getIconChartStyle(id)
	{
  		var icon = '';
  		switch(id)
  		{
    		case 'bar': icon = 'fas fa-chart-bar'; break;
    		case 'barstacked': icon = 'fas fa-chart-bar'; break;
    		case 'pie': icon = 'fas fa-chart-pie';break;
    		case 'line': icon = 'fas fa-chart-line';break;
    		case 'linestacked': icon = 'fas fa-chart-line';break;
    		default: icon = 'fas fa-chart-bar';
  		}

  		return icon;
	}


	function StatisticLayoutChanged()
	{
		let layoutID = $("input[name='IdcStatisticLayout']:checked").attr('id');

		switch ( layoutID )
		{
			case 'IdcStatisticLayout_1X1' 	: setLayout('l1x1');	break;
			case 'IdcStatisticLayout_2X1' 	: setLayout('l2x1');	break;
			case 'IdcStatisticLayout_1_1X2' : setLayout('l1_1x2');	break;
			case 'IdcStatisticLayout_1X2' 	: setLayout('l1x2');	break;
			case 'IdcStatisticLayout_2X2' 	: setLayout('l2x2');	break;
		}
	}
