	TaskMasterDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcTaskMasterDT.Properties (); }
		}
	];

	TaskDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcTaskDT.Properties (); }
		}
	];

	TaskStatusDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcTaskStatusDT.Properties (); }
		}
	];

	let IdcTaskMasterDT;
	let GTaskForSelection;
	let GTaskScope;
	let GTaskScopeID;
	
	function InitTaskPage ()
	{
		let ss = sessionStorage.getItem ( 'TaskPageInitialized' );

		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'TaskPageInitialized', true );

		GTaskForSelection 	=  0;
		GTaskScope 			= '';

		IdcTaskMasterDT = new C_DataTable ();
		IdcTaskMasterDT.DataSrcType		= 0;
		IdcTaskMasterDT.Ident 			= 'IdcTaskMasterDT';
		IdcTaskMasterDT.Container 		= 'IdcTaskMasterDTContainer';
		IdcTaskMasterDT.DataSrc 		= 'SubFW/database/task/get_task_master.php';
		IdcTaskMasterDT.DataFct			= TaskMasterDTGetData;
		IdcTaskMasterDT.SetColReorder 	( true );
		IdcTaskMasterDT.OnSelectChanged		( TaskMasterDTSelected 	);
		IdcTaskMasterDT.AddColumn ( 'id',						'id',	 			0, false, 0,   50,  false, '', 				'' );
		IdcTaskMasterDT.AddColumn ( 'dep_id',					'dep_id', 			0, false, 1,   50,  false, '', 				'' );
		IdcTaskMasterDT.AddColumn ( Translate('Department'),	'department',		1, true,  2, '15%', true,  '', 				'' );
		IdcTaskMasterDT.AddColumn ( Translate('Title'),			'title',			1, true,  3, '15%', true,  '', 				'' );
		IdcTaskMasterDT.AddColumn ( Translate('Description'),	'description',		1, true,  4, '15%', true,  '', 				'' );
		IdcTaskMasterDT.AddColumn ( Translate('Start date'),	'start_date',		1, true,  5, '10%', true,  'text-center',	'', DICOMDate2FmtDate );
		IdcTaskMasterDT.AddColumn ( Translate('End date'),		'end_date',			1, true,  6, '10%', true,  'text-center',	'', DICOMDate2FmtDate );
		IdcTaskMasterDT.AddColumn ( Translate('Recurrence'),	'recurrence',		1, true,  7, '25%', true,  '', 				'', TaskRecurrence );
		IdcTaskMasterDT.AddColumn ( Translate('Day of week'),	'day_of_week',		1, true,  8, '15%', true,  'text-center',	'', TaskDay );
		IdcTaskMasterDT.AddColumn ( Translate('Active'),		'active',			1, true,  9, '15%', true,  'text-center',	'', TaskActive );
		IdcTaskMasterDT.AddColumn ( Translate('Staff'),			'staff_member_ids',	1, false,10, '15%', false,  '',				'' );
		IdcTaskMasterDT.AddColumn ( 'closing_type',				'closing_type',		1, false,11, '15%', false,  '',				'' );
		IdcTaskMasterDT.SetColumnFilter ( 'department', 	'<div class="m-0 p-0 ps-2 pe-2"><select class="form-select m-0 p-0 ps-2" id="IdcTaskMasterDepartmentFilter" aria-label="Default select example" onchange="IdcTaskMasterDT.Refresh();"><option value="-1">*</option></select></div>' );
		IdcTaskMasterDT.SetColumnFilter ( 'title',  		'<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcTaskMasterTitleFilter" class="form-control pt-0 pb-0" oninput="IdcTaskMasterDT.Refresh()" type="text" placeholder="'+Translate("Title")+'"></div>' );
		IdcTaskMasterDT.SetColumnFilter ( 'description',  	'<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcTaskMasterDescriptionFilter" class="form-control pt-0 pb-0" oninput="IdcTaskMasterDT.Refresh()" type="text" placeholder="'+Translate("Description")+'"></div>' );
		IdcTaskMasterDT.SetColumnFilter ( 'recurrence', 	'<div class="m-0 p-0 ps-2 pe-2"><select class="form-select m-0 p-0 ps-2" id="IdcTaskMasterRecurrenceFilter" aria-label="Default select example" onchange="IdcTaskMasterDT.Refresh();"><option value="-1">*</option><option value="0">'+Translate("Unique")+'</option><option value="1">'+Translate("Daily")+'</option><option value="2">'+Translate("Weekly")+'</option><option value="3">'+Translate("Monthly")+'</option><option value="4">'+Translate("Quaterly")+'</option><option value="5">'+Translate("Yearly")+'</option></select></div>' );
		/*
		IdcTaskMasterDT.SetColumnFilter ( 'fullname', 	'<div class="m-0 p-0 ps-2 pe-2"><select class="form-select m-0 p-0 ps-2" id="IdcTaskAssignedToFilter" aria-label="Default select example" onchange="IdcTaskMasterDT.Refresh();"><option value="-1">*</option></select></div>' );
		*/
		IdcTaskMasterDT.LoadUserCfg ( G_USE_ID );


		IdcTaskDT = new C_DataTable ();
		IdcTaskDT.DataSrcType		= 0;
		IdcTaskDT.Ident 			= 'IdcTaskDT';
		IdcTaskDT.Container 		= 'IdcTaskDTContainer';
		IdcTaskDT.DataSrc 			= 'SubFW/database/task/get_task.php';
		IdcTaskDT.DataFct			= TaskDTGetData;
		IdcTaskDT.SetColReorder 	( true );
		IdcTaskDT.OnSelectChanged	( TaskDTSelected 	);
		IdcTaskDT.AddColumn ( 'id',						'id',	 			0, false, 0,   50,  false, '', 				'' );
		IdcTaskDT.AddColumn ( Translate('Title'),		'title',			1, true,  1, '35%', true,  '', 				'' );
		IdcTaskDT.AddColumn ( Translate('Description'),	'description',		1, true,  2, '55%', true,  '', 				'' );
		IdcTaskDT.AddColumn ( Translate('Due date'),	'due_date',			1, true,  3, '20%', true,  'text-center',	'', DICOMDate2FmtDate );
		IdcTaskDT.AddColumn ( Translate('Status'),		'status_name',		1, true,  4, '20%', true,  '',				'', Translate );
		IdcTaskDT.AddColumn ( Translate('Closed'),		'closing_date',		1, true,  5, '20%', true,  'text-center',	'', DICOMDate2FmtDate );
		IdcTaskDT.SetColumnFilter ( 'title',  		'<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcTaskTitleFilter" class="form-control pt-0 pb-0" oninput="IdcTaskDT.Refresh()" type="text" placeholder="'+Translate("Title")+'"></div>' );
		IdcTaskDT.SetColumnFilter ( 'description',  '<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcTaskDescriptionFilter" class="form-control pt-0 pb-0" oninput="IdcTaskDT.Refresh()" type="text" placeholder="'+Translate("Description")+'"></div>' );
		IdcTaskDT.SetColumnFilter ( 'status_name', 	'<div class="m-0 p-0 ps-2 pe-2"><select class="form-select m-0 p-0 ps-2" id="IdcTaskStatusFilter" aria-label="Default select example" onchange="IdcTaskDT.Refresh();"><option value="-1">*</option></select></div>' );
		IdcTaskDT.LoadUserCfg ( G_USE_ID );


		IdcTaskStatusDT = new C_DataTable ();
		IdcTaskStatusDT.DataSrcType		= 0;
		IdcTaskStatusDT.Ident 			= 'IdcTaskStatusDT';
		IdcTaskStatusDT.Container 		= 'IdcTaskStatusDTContainer';
		IdcTaskStatusDT.DataSrc 		= 'SubFW/database/task/get_task_status.php';
		IdcTaskStatusDT.DataFct			= TaskStatusDTGetData;
		IdcTaskStatusDT.SetColReorder 	( true );
		IdcTaskStatusDT.OnSelect		( TaskStatusDTSelected 	);
		IdcTaskStatusDT.AddColumn ( 'id',						'id', 			0, false, 0,   50,  false, '', 				'' );
		IdcTaskStatusDT.AddColumn ( Translate('Member'),		'member',		1, true,  1, '35%', true,  '', 				'' );
		IdcTaskStatusDT.AddColumn ( Translate('Status'),		'status_name',	1, true,  2, '35%', true,  '', 				'', Translate );
		IdcTaskStatusDT.AddColumn ( Translate('Date'),			'status_date',	1, true,  3, '35%', true,  'text-center', 	'', DICOMDate2FmtDate );
		IdcTaskStatusDT.AddColumn ( Translate('Comment'),		'comment',		1, true,  4, '35%', true,  '', 				'' );
		IdcTaskStatusDT.LoadUserCfg ( G_USE_ID );
		

		$(document).ready(function () 
		{
			IdcTaskMasterSplitter1_2 	= new C_Splitter ( "IdcTaskMasterSplitter1_2" );
			IdcTaskMasterSplitter1_2.LoadUserCfg		( G_USE_ID );

			IdcTaskSplitter1_2 	= new C_Splitter ( "IdcTaskSplitter1_2" );
			IdcTaskSplitter1_2.LoadUserCfg		( G_USE_ID );


			let recurrenceSelect = document.getElementById ('IdcTaskMasterRecurrence');
			recurrenceSelect.addEventListener ( 'change', TaskMasterRecurrenceChanged );
			
			IdcTaskMasterDT.Create ();
			// IdcTaskMasterDT.SetColumnVisibility ( 5, false );

			IdcTaskDT.Create ();

			IdcTaskStatusDT.Create ();

			IdcTaskMasterUsersCBMenu = new C_CheckboxMenu ( "IdcTaskMasterUsersContainer", "IdcTaskMasterUsersCBMenu", Translate("Click here to select users") );
			InitJobUserCBList ( IdcTaskMasterUsersCBMenu );

			context.attach ( '#IdcTaskMasterDT', TaskMasterDTListMenu );
			IdcTaskMasterDT.SetRowToSelect ( 'first_row' );

			context.attach ( '#IdcTaskDT', TaskDTListMenu );
			IdcTaskDT.SetRowToSelect ( 'first_row' );

			context.attach ( '#IdcTaskStatusDT', TaskStatusDTListMenu );
			IdcTaskStatusDT.SetRowToSelect ( 'first_row' );

			$('#' + IdcTaskMasterDT.Ident +' tbody').on('click', '.Task_Link', function () 
			{
				let tr = $(this).closest('tr');
					
				TaskLinkClicked ( tr );
			} );
			
			FillDepartmentsList ( 'IdcTaskMasterDepartmentFilter', -1, true );
			FillDepartmentsList ( 'IdcTaskMasterDepartment', -1 );
			
			FillStatusList ( 'IdcTaskStatusFilter', 'action');
			// FillStatusList ( 'IdcTaskStatus', 'action');
			
			// FillStaffList	( 'IdcTaskAssignedToFilter' );
			// FillStaffList	( 'IdcTaskAssignedTo' );

			document.getElementById ('IdcTaskMasterTab' ).addEventListener	( 'shown.bs.tab', () => { TaskMasterTabShown (); } 		);
			document.getElementById ('IdcTaskTab' 	   ).addEventListener 	( 'shown.bs.tab', () => { TaskTabShown (); 		 } 		);

			switchLanguage ( CurrentLanguage );	


			$('#IdcDivTask').on ( 'show', function () {console.log ("SHOW !!!!!!"); })
		});
	}

	function TaskMasterRecurrenceChanged ()
	{
		let recurrence = $('#IdcTaskMasterRecurrence').val ();

		switch ( recurrence )
		{
			case '0': // Unique
			case '1': // Daily
				$('#IdcTaskMasterDayRow').hide ();
				break;

			default:
				$('#IdcTaskMasterDayRow').show ();
				break;
		}
	}

	function TaskRecurrence ( d )
	{
		let ret = '';

		switch ( d )
		{
			case '0': ret = Translate('None-f');	break;
			case '1': ret = Translate('Daily');		break;
			case '2': ret = Translate('Weekly');	break;
			case '3': ret = Translate('Monthly');	break;
			case '4': ret = Translate('Quaterly');	break;
			case '5': ret = Translate('Yearly');	break;
		}

		return ret;
	}

	function TaskDay ( d )
	{
		let ret = '';

		switch ( d )
		{
			case '-2': 	ret = Translate ('N.A.');	break;
			case '-1': 	ret = Translate ('Indif.');	break;
			case '0': 	ret = Translate ('Su.');	break;
			case '1': 	ret = Translate ('Mo.');	break;
			case '2': 	ret = Translate ('Tu.');	break;
			case '3': 	ret = Translate ('We.');	break;
			case '4': 	ret = Translate ('Th.');	break;
			case '5': 	ret = Translate ('Fr.');	break;
			case '6': 	ret = Translate ('Sa.');	break;
		}

		return ret;
	}

	function TaskActive ( d )
	{
		let ret = '';

		if ( d == 't' ) ret = Translate ( 'Yes' ); else ret = Translate ( 'No' );

		return ret;
	}

	function TaskMasterDTGetData ( d )
	{
		let dep_id				= $('#IdcTaskMasterDepartmentFilter :selected').val ();
		let title 				= $('#IdcTaskMasterTitleFilter').val ();
		let description			= $('#IdcTaskMasterDescriptionFilter').val ();
		let recurrence			= $('#IdcTaskMasterRecurrenceFilter').val ();
		// let personincharge		= $('#IdcTaskAssignedToFilter :selected').val ();
		
		d.dep_id  			= dep_id;
		d.title 			= title;
		d.description 		= description;
		d.recurrence 		= recurrence;
		// d.personincharge 	= personincharge;
		d.fromdate  		= '01/01/1999';
		d.todate 			= '31/12/2025';
		d.forselection 		= GTaskForSelection;
		d.scope 			= GTaskScope;
		d.scopeid 			= GTaskScopeID;

		return $.extend( {}, d );
	}

	function TaskDTGetData ( d )
	{
		let dep_id				= $('#IdcTaskDepartmentFilter :selected').val ();
		let status_id			= $('#IdcTaskStatusFilter :selected').val ();
		let personincharge		= $('#IdcTaskAssignedToFilter :selected').val ();
		let description			= $('#IdcTaskDescriptionFilter').val ();
		let title				= $('#IdcTaskTitleFilter').val ();

		d.dep_id  			= dep_id;
		d.title  			= title;
		d.status_id			= status_id;
		d.personincharge 	= personincharge;
		d.description  		= description;
		d.fromdate  		= '01/01/1999';
		d.todate 			= '31/12/2025';
		d.forselection 		= GTaskForSelection;
		d.scope 			= GTaskScope;
		d.scopeid 			= GTaskScopeID;

		return $.extend( {}, d );
	}

	function TaskStatusDTGetData ( d )
	{
		let task_id = $('#IdcDivTask' ).data ( 'task_id' );

		d.id  			= task_id;

		return $.extend( {}, d );
	}

	function TaskShortcut ( shortcut_pin )
	{
		let bmpLink		= 'pin_off.png';
		let titleLink   = 'Click to link';
		let clickable	= 'imgclickable';
		let height 		= '18px'

		if  ( shortcut_pin > 0 )
		{
			bmpLink 	= 'pin_on.png';
			titleLink  = 'Click to unlink';
			clickable	= 'imgclickable';
			height 		= '22px'
		}

		let tmp  = '<img class=\"Task_Link '+clickable+'  ps-2 pe-2\" title=\"'+Translate ( titleLink )+'\" src=\"'+G_ServerFolder+'/eoQUAL/SubFW/bmp/'+bmpLink+'\" style=\"height: '+height+'; width: auto;\"></img>';

		return tmp;
	}
	
	function TaskMasterDTSelected ( rowsIdx )
	{
		let id 				= -1;
		let dep_id			= -1;
		let status_id 		= -1;
		let title			= "";
		let description		= "";
		let start_date		= "";
		let end_date		= "";
		let recurrence  	= -1;
		let day 			= -1;
		let active 			= false;
		let closing_type	= -1;
		
		let staff_member_ids = null;
		
		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 				= $('#IdcTaskMasterDT').DataTable().row( rowIdx ).data().id;
			dep_id			= $('#IdcTaskMasterDT').DataTable().row( rowIdx ).data().dep_id;
			title			= $('#IdcTaskMasterDT').DataTable().row( rowIdx ).data().title;
			description 	= $('#IdcTaskMasterDT').DataTable().row( rowIdx ).data().description;
			start_date		= $('#IdcTaskMasterDT').DataTable().row( rowIdx ).data().start_date;
			end_date		= $('#IdcTaskMasterDT').DataTable().row( rowIdx ).data().end_date;
			recurrence  	= $('#IdcTaskMasterDT').DataTable().row( rowIdx ).data().recurrence;
			day				= $('#IdcTaskMasterDT').DataTable().row( rowIdx ).data().day_of_week;
			active			= $('#IdcTaskMasterDT').DataTable().row( rowIdx ).data().active;
			closing_type	= $('#IdcTaskMasterDT').DataTable().row( rowIdx ).data().closing_type;

			staff_member_ids	= IdcTaskMasterDT.GetRowData ( rowIdx ).staff_member_ids;
			
		}

		$('#IdcDivTask' ).data ( 'task_master_id', id );
			$('#IdcTaskMasterTitle').val ( title );
			$('#IdcTaskMasterDescription').val ( description );
			$('#IdcTaskMasterDepartment').val ( dep_id ).change();
			$('#IdcTaskMasterStartDate').val ( DICOMDate2StdDate(start_date) );
			$('#IdcTaskMasterEndDate').val ( DICOMDate2StdDate(end_date) );
			$('#IdcTaskMasterRecurrence').val (recurrence);
			$('#IdcTaskMasterActive').prop('checked', (active=='t')? true : false );
			$('#IdcTaskMasterClosingCriteria').val (closing_type);

			TaskMasterRecurrenceChanged ();


		$('input[name="IdcTaskMasterDay"][value="'+day+'"]').prop('checked', true);

		IdcTaskMasterUsersCBMenu.UnselectAll ();
		
		if ( staff_member_ids != null && staff_member_ids.length > 0 )
		{
			let staffMembersIDs = staff_member_ids.split (',');

			IdcTaskMasterUsersCBMenu.SelectElementIdent2 ( staffMembersIDs );
		}			


	}

	function TaskDTSelected ( rowsIdx )
	{
		let id 				= -1;
		let title			= "";
		let description		= "";
		let status_name		= "";
		let closing_date	= "";
		
		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 				= $('#IdcTaskDT').DataTable().row( rowIdx ).data().id;
			title			= $('#IdcTaskDT').DataTable().row( rowIdx ).data().title;
			description 	= $('#IdcTaskDT').DataTable().row( rowIdx ).data().description;
			status_name 	= $('#IdcTaskDT').DataTable().row( rowIdx ).data().status_name;
			closing_date 	= $('#IdcTaskDT').DataTable().row( rowIdx ).data().closing_date;
		}

		$('#IdcDivTask' ).data ( 'task_id', id );
		$('#IdcTaskTitle').val ( title );
		$('#IdcTaskDescription').val ( description );

		if ( closing_date != null && closing_date.length > 0 )
			status_name = Translate (status_name) + ' le ' + DICOMDate2FmtDate ( closing_date );
		else
			status_name = Translate (status_name);

		$('#IdcTaskGlobalStatus').text ( status_name );

		IdcTaskStatusDT.Refresh ();
	}

	function TaskStatusDTSelected ( rowsIdx )
	{

	}
	
	function OnDeleteTaskOK ( response )
	{
		if ( response != '-1')
			IdcTaskMasterDT.Refresh ();
		else
			OnDeleteTaskError ();
	}

	function OnDeleteTaskError ()
	{
		MsgWarning ( Translate("Unable to delete task !!!") );
	}
	
	
	function DeleteTask ()
	{
		let selRows = IdcTaskMasterDT.GetSelectedRows ();

		if ( selRows.length == 1 )
		{
			let id = IdcTaskMasterDT.GetRowData ( selRows [0] ).id;

			// PostASyncData ( "SubFW/database/task/DeleteTask.php", "id="+id, 'application/x-www-form-urlencoded', OnDeleteTaskOK, OnDeleteTaskError );

			$.post (
				"./SubFW/database/task/delete_task_master.php",
				{
					id: 	id
				},
					function (data, status)
					{		
						console.log ( " data.status : " + data.status );
						console.log ( " data.id : " + data.id );

						OnDeleteTaskOK ( data.id );
					}
				);
		}
	}
	
	function TaskDelete ()
	{
		let selRows = IdcTaskMasterDT.GetSelectedRows ();

		if ( selRows.length == 1 )
		{
			MsgYesNo ( Translate("Delete selected task ?"), DeleteTask );
		}
		else
		{
			MsgWarning ( Translate("No task selected !!!") );
		}
	}

	function TaskMasterAdd ()
	{
		$.post (
				"./SubFW/database/task/save_task_master.php",
				{
					id: 	-1
				},
					function (data, status)
					{		
						console.log ( " data.status : " + data.status );
						console.log ( " data.id : " + data.id );

						IdcTaskMasterDT.SetRowToSelect ( 'id', data.id );
						IdcTaskMasterDT.Refresh ();
					}
				);
	}

	function TaskMasterSaved ( data, status )
	{
		console.log ( "TaskMasterSaved..." );

		console.log ( " data.status : " + data.status );
		console.log ( " data.id : " + data.id );

		IdcTaskMasterDT.SetRowToSelect ( 'id', data.id );
		IdcTaskMasterDT.Refresh ();

		$.post (
				"./SubFW/database/task/generate_tasks.php",
				{
					// id: 	id
				},
					function (data, status)
					{		
						console.log ( " data.status : " + data.status );
						console.log ( " data.id : " + data.id );
					}
				);
	}

	function TaskMasterSave ()
	{
		let id 				= $('#IdcDivTask' ).data ( 'task_master_id' );
		let title			= $('#IdcTaskMasterTitle').val ();
		let description		= $('#IdcTaskMasterDescription').val ();
		let dep_id			= $('#IdcTaskMasterDepartment').val ();
		let start_date		= $('#IdcTaskMasterStartDate').val ();
		let end_date		= $('#IdcTaskMasterEndDate').val ();
		let recurrence		= $('#IdcTaskMasterRecurrence').val ();
		let day 			= $('input[name="IdcTaskMasterDay"]:checked').val();
		let active 			= $('#IdcTaskMasterActive').prop('checked');
		let closing_type	= $('#IdcTaskMasterClosingCriteria').val ();

		let users = IdcTaskMasterUsersCBMenu.GetSelection ();

		let tmp = new Array();
		for ( let i=0; i<users.length; i++ )
		{
			tmp.push  ( users [i][1] );
		}
		let staff_members = JSON.stringify(tmp);

		$.post (
				"./SubFW/database/task/save_task_master.php",
				{
					id: 			id,
					dep_id: 		dep_id,
					title: 			title,
					description: 	description,
					start_date:  	start_date,
					end_date:  		end_date,
					recurrence: 	recurrence,
					day: 			day,
					active: 		active,
					staff_members: 	staff_members,
					closing_type: 	closing_type
				},
					function (data, status)
					{		
						TaskMasterSaved ( data, status );
					}
				);
	}


	function TaskSave ()
	{
		console.log ( "TaskSave..." );
	}

	function SetTaskInfo ( forselection, scope, scopeid )
	{
		GTaskForSelection   = forselection;
		GTaskScope 			= scope;
		GTaskScopeID		= scopeid;

		if ( GTaskForSelection == 1 )
			IdcTaskMasterDT.SetColumnVisibility ( 5, true );
		else
			IdcTaskMasterDT.SetColumnVisibility ( 5, false );
	}


	function TaskLinkClicked ( tr )
	{
		console.log ( "TaskLinkClicked..." );

		let row = $('#'+IdcTaskMasterDT.Ident).DataTable ().row ( tr );

		let action = 'add';
		if ( row.data().shortcut_pin == 1 )
			action = 'delete';

		$.post (
			"./SubFW/database/task/ActionLink.php",
			{
				action: action,
				actionid: row.data().id,
				scope: GTaskScope,
				scopeid: GTaskScopeID,
				actionlinkid: row.data().actionlinkid
			},
			function (data, status)
			{
				console.log ( " data.status : " + data.status );
				console.log ( " data.id : " + data.id );
				if ( data.actionlinkid != -1 )
					IdcTaskMasterDT.SetRowToSelect ( 'id', data.actionlinkid );
				else
					IdcTaskMasterDT.SetRowToSelect ( 'first_row' );
				IdcTaskMasterDT.Refresh ();
			}
		);
	}

	

	function TaskMasterTabShown ()
	{
		console.log ( "TaskMasterTabShown..." );
	}

	function TaskTabShown ()
	{
		console.log ( "TaskTabShown..." );

		IdcTaskDT.Refresh ();
	}