	TaskWorkingDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcTaskWorkingDT.Properties (); }
		}
	];

	TaskWorkingStatusDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcTaskWorkingStatusDT.Properties (); }
		}
	];

	function InitTaskWorkingPage ()
	{
		let ss = sessionStorage.getItem ( 'TaskWorkingPageInitialized' );

		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'TaskWorkingPageInitialized', true );

		IdcTaskWorkingDT = new C_DataTable ();
		IdcTaskWorkingDT.DataSrcType	= 0;
		IdcTaskWorkingDT.Ident 			= 'IdcTaskWorkingDT';
		IdcTaskWorkingDT.Container 		= 'IdcTaskWorkingDTContainer';
		IdcTaskWorkingDT.DataSrc 		= 'SubFW/database/task/get_task_working.php';
		IdcTaskWorkingDT.DataFct		= TaskWorkingDTGetData;
		IdcTaskWorkingDT.SetColReorder 	( true );
		IdcTaskWorkingDT.OnSelectChanged( TaskWorkingDTSelected 	);
		IdcTaskWorkingDT.AddColumn ( 'id',						'id',	 			0, false, 0,   50,  false, '', 				'' );
		IdcTaskWorkingDT.AddColumn ( Translate('Title'),		'title',			1, true,  1, '35%', true,  '', 				'' );
		IdcTaskWorkingDT.AddColumn ( Translate('Description'),	'description',		1, true,  2, '55%', true,  '', 				'' );
		IdcTaskWorkingDT.AddColumn ( Translate('Due date'),		'due_date_fmt',		1, true,  3, '20%', true,  'text-center',	'', TaskWorkingDate );
		IdcTaskWorkingDT.AddColumn ( Translate('Status'),		'status_name',		1, true,  4, '20%', true,  '',				'', Translate );
		IdcTaskWorkingDT.AddColumn ( Translate('Date'),			'status_date',		1, true,  5, '20%', true,  '',				'', DICOMDate2FmtDate );
		IdcTaskWorkingDT.AddColumn ( Translate('Comment'),		'comment',			1, true,  6, '20%', true,  '',				'' );
		IdcTaskWorkingDT.AddColumn ( 'status_id',				'status_id',		0, false, 7,    50, false, '', 				'' );
		IdcTaskWorkingDT.SetColumnFilter ( 'title',  		'<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcTaskWorkingTitleFilter" class="form-control pt-0 pb-0" oninput="IdcTaskWorkingDT.Refresh()" type="text" placeholder="'+Translate("Title")+'"></div>' );
		IdcTaskWorkingDT.SetColumnFilter ( 'description',  '<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcTaskWorkingDescriptionFilter" class="form-control pt-0 pb-0" oninput="IdcTaskWorkingDT.Refresh()" type="text" placeholder="'+Translate("Description")+'"></div>' );
		IdcTaskWorkingDT.SetColumnFilter ( 'status_name', 	'<div class="m-0 p-0 ps-2 pe-2"><select class="form-select m-0 p-0 ps-2" id="IdcTaskWorkingStatusFilter" aria-label="Default select example" onchange="IdcTaskWorkingDT.Refresh();"><option value="-1">*</option></select></div>' );
		IdcTaskWorkingDT.LoadUserCfg ( G_USE_ID );


		IdcTaskWorkingStatusDT = new C_DataTable ();
		IdcTaskWorkingStatusDT.DataSrcType		= 0;
		IdcTaskWorkingStatusDT.Ident 			= 'IdcTaskWorkingStatusDT';
		IdcTaskWorkingStatusDT.Container 		= 'IdcTaskWorkingStatusDTContainer';
		IdcTaskWorkingStatusDT.DataSrc 			= 'SubFW/database/task/get_task_working_status.php';
		IdcTaskWorkingStatusDT.DataFct			= TaskWorkingStatusDTGetData;
		IdcTaskWorkingStatusDT.SetColReorder 	( true );
		IdcTaskWorkingStatusDT.OnSelectChanged		( TaskWorkingStatusDTSelected 	);
		IdcTaskWorkingStatusDT.AddColumn ( 'id',					'id', 			0, false, 0,   50,  false, '', 				'' );
		IdcTaskWorkingStatusDT.AddColumn ( Translate('Member'),		'member',		1, true,  1, '35%', true,  '', 				'' );
		IdcTaskWorkingStatusDT.AddColumn ( Translate('Status'),		'status_name',	1, true,  2, '35%', true,  '', 				'', Translate );
		IdcTaskWorkingStatusDT.AddColumn ( Translate('Date'),		'status_date',	1, true,  3, '35%', true,  'text-center', 	'', DICOMDate2FmtDate );
		IdcTaskWorkingStatusDT.AddColumn ( Translate('Comment'),	'comment',		1, true,  4, '35%', true,  '', 				'' );
		IdcTaskWorkingStatusDT.LoadUserCfg ( G_USE_ID );

		$(document).ready(function () 
		{
			IdcTaskWorkingSplitter1_2 	= new C_Splitter ( "IdcTaskWorkingSplitter1_2" );
			IdcTaskWorkingSplitter1_2.LoadUserCfg		( G_USE_ID );

			IdcTaskWorkingDT.Create ();
			context.attach ( '#IdcTaskWorkingDT', TaskWorkingDTListMenu );
			IdcTaskWorkingDT.SetRowToSelect ( 'first_row' );

			IdcTaskWorkingStatusDT.Create ();
			IdcTaskWorkingStatusDT.SetRowToSelect ( 'first_row' );
			context.attach ( '#IdcTaskWorkingStatusDT', TaskWorkingStatusDTListMenu );

			FillStatusList ( 'IdcTaskWorkingStatusFilter', 	'action');
			FillStatusList ( 'IdcTaskWorkingStatus', 		'action');
		});
	}

	function TaskWorkingDate ( d, ident, row, col )
	{
		const fmtDate = DICOMDate2FmtDate ( d );

		let table = $('#'+ident).DataTable ();

		let status_id = table.cell ( row, 7 ).data ();

		let bg_color = '';
		if ( status_id != '4' )
		{
			const nbDays = GetDaysFromToday ( d );	

			if ( nbDays <= 0 )
				bg_color = 'bg-danger';
			else
				if ( nbDays <= 5 && nbDays > 0 )
					bg_color = 'bg-warning';
		}
		
		
		if ( bg_color != '' )
			return '<div class="'+bg_color+'">' + fmtDate + "</div>";
		else
			return '<div>' + fmtDate + "</div>";
	}

	
	function TaskWorkingDTGetData ( d )
	{
		let dep_id				= $('#IdcTaskDepartmentFilter :selected').val ();
		let status_id			= $('#IdcTaskWorkingStatusFilter :selected').val ();
		let description			= $('#IdcTaskWorkingDescriptionFilter').val ();
		let title				= $('#IdcTaskWorkingTitleFilter').val ();

		d.dep_id  			= dep_id;
		d.staff_member_id   = G_USE_ID;
		d.title  			= title;
		d.status_id			= status_id;
		d.description  		= description;
		d.fromdate  		= '01/01/1999';
		d.todate 			= '31/12/2025';
		d.nearest_task_only = ($('#IdcTaskWorkingNextOnly').prop ('checked') == true)? 1 : 0;

		return $.extend( {}, d );
	}

	function TaskWorkingStatusDTGetData ( d )
	{
		console.log ( "TaskWorkingStatusDTGetData..." );

		let task_id = $('#IdcDivTaskWorking' ).data ( 'task_id' );

		console.log ( " task_id : " + task_id );

		d.id  			= task_id;

		return $.extend( {}, d );
	}

	function TaskWorkingDTSelected ( rowsIdx )
	{
		let id 			= -1;
		let status_id	= -1;
		let title		= "";
		let description	= "";
		let comment		= "";
		console.log ("rowsIdx.length : " + rowsIdx.length );
		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 			= $('#IdcTaskWorkingDT').DataTable().row( rowIdx ).data().id;
			title		= $('#IdcTaskWorkingDT').DataTable().row( rowIdx ).data().title;
			description = $('#IdcTaskWorkingDT').DataTable().row( rowIdx ).data().description;
			comment 	= $('#IdcTaskWorkingDT').DataTable().row( rowIdx ).data().comment;
			status_id 	= $('#IdcTaskWorkingDT').DataTable().row( rowIdx ).data().status_id;
		}	
			$('#IdcDivTaskWorking' ).data ( 'task_id', id );
			$('#IdcTaskWorkingTitle').val ( title );
			$('#IdcTaskWorkingDescription').val ( description );
			$('#IdcTaskWorkingComment').val ( comment );
			$('#IdcTaskWorkingStatus').val ( status_id ).change();

			IdcTaskWorkingStatusDT.Refresh ();
		
	}

	function TaskWorkingStatusDTSelected ( rowsIdx )
	{

	}

	function TaskWorkingNextOnlyClicked ()
	{
		console.log ( "TaskWorkingNextOnlyClicked..." );

		IdcTaskWorkingDT.Refresh ();
	}

	function TaskWorkingSave ()
	{
		console.log ( "TaskWorkingSave..." );

		let task_id 			= $('#IdcDivTaskWorking' ).data ( 'task_id' );
		let comment 			= $('#IdcTaskWorkingComment').val ();
		let status_id 			= $('#IdcTaskWorkingStatus').val ();
		let staff_member_id 	= G_USE_ID;

		$.post (
				"./SubFW/database/task/update_task_link.php",
				{
					task_id: 			task_id,
					status_id: 			status_id,
					staff_member_id:  	staff_member_id,
					comment: 			comment
				},
					function (data, status)
					{		
						console.log ( " data.status : " + data.status );
						console.log ( " data.id : " + data.id );

						IdcTaskWorkingDT.Refresh ();
					}
				);
	}