<?php
require_once 'SubFW/autoload.php';
?>

<!doctype html>

<html lang="en" style="height: 100%; font-size: 12px;">

	<head>
		<meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
		
		<meta charset="utf-8">
		
		<meta name="viewport" content="width=device-width, initial-scale=1">
		
		<title>
			eoQUAL
		</title>
		
		<link rel="icon" href="SubFW/bmp/back.png" type="image/png">

		<?php
			$libmanager = new eoLibrariesManagerQual ();
			$libmanager->init_page();
			$libmanager->render_library ();
		?>

		<script src="https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.js"></script>

		<link href="https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.snow.css" rel="stylesheet">

		<!-- <script type="text/javascript" src="http://178.33.232.121:1025/web-apps/apps/api/documents/api.js"></script> -->

		<script src='SubFW/js/i18n.js' ></script>

		<!-- <script src="http://192.168.64.184/web-apps/apps/api/documents/api.js"></script> -->

		<!-- create DOCX -->
		<script src="https://cdn.jsdelivr.net/npm/docx@8.2.2/build/index.umd.js"></script>

		<!-- create XLSX -->
		<script src="https://cdn.jsdelivr.net/npm/xlsx@0.18.5/dist/xlsx.full.min.js"></script>
		
	</head>
	

	<body>
						
		<div id="IdcMainDiv" class="container-fluid max-vh-100 vh-100 bg-light">
			<div class="h-100 d-flex flex-column m-0 p-0 w-100">
				<div class="row border-bottom m-0 p-0">
						
					<nav id="idnavbar" class="navbar navbar-expand navbar-dark bg-gray1 static-top m-0 p-0 pb-2 pt-2 w-100" >
					
						<a href="http://ximeo.be" class="d-flex align-items-center col-md-3 mb-2 mb-md-0 text-dark text-decoration-none">
							<img src="SubFW/bmp/ximeo.png" alt="XIMEO" style="width: 90px;"></img>
						</a>
													
						<div class="collapse navbar-collapse">
						
							<ul class="nav col-12 col-md-auto mb-2 justify-content-center mb-md-0">
							</ul>

							<div class="container">
								<div id="IdcLanguageDiv" class="row">
								</div>
							</div>

							<div class="w-100 text-end">
								<button type="button" data-langkey="Login..." class="ximeo_button" onclick="OnUserLogin ();"></button>
							</div>
						</div>
					
					</nav>
				</div>
							
				<div id="IdcMainDivRow" class="row bg-light flex-grow-1 h-25 p-0">
					<div id="IdcWelcomeDiv" class="w-100 h-100 bg-light" style="display: block;">
						<div class="pt-2">
							<h1 data-langkey="eoQUAL, the Quality System Management by XIMEO"></h1>
						</div>
					
						<div id="IdcWelcomeCarouselDiv" class="carousel slide" data-bs-ride="carousel">
							<div class="carousel-indicators">
								<button type="button" data-bs-target="#IdcWelcomeCarouselDiv" data-bs-slide-to="0" class="active" aria-current="true" aria-label="Slide 1"></button>
								<button type="button" data-bs-target="#IdcWelcomeCarouselDiv" data-bs-slide-to="1" aria-label="Slide 2"></button>
								<button type="button" data-bs-target="#IdcWelcomeCarouselDiv" data-bs-slide-to="2" aria-label="Slide 3"></button>
							</div>
    
							<div class="carousel-inner h-100">
								<div class="carousel-item active">
									<svg class="bd-placeholder-img" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" aria-hidden="false" preserveAspectRatio="xMidYMid slice" focusable="false"><rect width="100%" height="100%" fill="#7a0058"/></svg>

									<div class="container">
										<div class="carousel-caption text-start">
											<h1 data-langkey="Statistic"></h1>
											<p>Un outil statistique largement paramétrable.</p>
											<p><a class="btn btn-lg btn-primary" data-langkey="Learn more..." href="https://www.ximeo.be/eoqual.html"></a></p>
										</div>
									</div>
								</div>
								<div class="carousel-item">
									<svg class="bd-placeholder-img" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" aria-hidden="false" preserveAspectRatio="xMidYMid slice" focusable="false"><rect width="100%" height="100%" fill="#7a0058"/></svg>

									<div class="container">
										<div class="carousel-caption text-start">
											<h1>Auto-audit</h1>
											<p>Réaliser vos auto-audits de manière simple et intuitive.</p>
											<p><a class="btn btn-lg btn-primary" data-langkey="Learn more..."  href="https://www.ximeo.be/eoqual.html"></a></p>
										</div>
									</div>
								</div>
								<div class="carousel-item">
									<svg class="bd-placeholder-img" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" aria-hidden="false" preserveAspectRatio="xMidYMid slice" focusable="false"><rect width="100%" height="100%" fill="#7a0058"/></svg>

									<div class="container">
										<div class="carousel-caption text-start">
											<h1>Multi-référentiels</h1>
											<p>BQUADRIL, BQUAANUM, NF-S99.</p>
											<p><a class="btn btn-lg btn-primary" data-langkey="Learn more..." href="https://www.ximeo.be/eoqual.html"></a></p>
										</div>
									</div>
								</div>
							</div>
							<button class="carousel-control-prev" type="button" data-bs-target="#IdcWelcomeCarouselDiv" data-bs-slide="prev">
								<span class="carousel-control-prev-icon" aria-hidden="false"></span>
								<span class="visually-hidden">Previous</span>
							</button>
							<button class="carousel-control-next" type="button" data-bs-target="#IdcWelcomeCarouselDiv" data-bs-slide="next">
								<span class="carousel-control-next-icon" aria-hidden="false"></span>
								<span class="visually-hidden">Next</span>
							</button>
						</div>
					
						<div class="position-absolute bottom-0" style="width: 98%;">
							<footer class="w-100 py-0 p-0">
								<div class="d-flex justify-content-between py-0 my-0 border-top">
									<p>&copy; 2024 XIMEO SA. All rights reserved.</p>
								</div>
							</footer>
						</div>
					</div>
				</div>
			</div>
		
			<div id="IdcUserAccess"  class="modal" tabindex="-1" role="dialog" aria-hidden="false">
				
				<div class="modal-dialog modal-sm modal-dialog-centered" role="document">
					<div class="modal-content">
										
						<div class="modal-header p-3 pb-3 pt-3 border-bottom bg-light">
							<h5 class="fw-bold mb-0" data-langkey="Connection to eoQUAL"></h5>
							<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" onclick="CloseLoginDlg();"></button>
						</div>
										
						<div class="modal-body">
							<form>			
							<div id="IdcUserErrorLogin" style="display: none;" class="form-floating mb-3">
								<small class="text-danger" data-langkey="Incorrect username or password"></small>
							</div>
									
							<div class="form-floating mb-2">
								<input type="text" class="form-control rounded-4" id="IdcUserIdent" placeholder="Login">
								<label for="IdcUserIdent" data-langkey="Identifier">Identifier</label>
							</div>
							<div class="form-floating mb-3">
								<input type="password" class="form-control rounded-4" id="IdcUserPassword" placeholder="Password" autocomplete="off">
								<label for="IdcUserPassword" data-langkey="Password">Password</label>
							</div>
							</form>
						</div>
						
						<div class="modal-footer">
							<button type="button" class="ximeo_button ximeo_bg-dark-2" data-dismiss="modal" data-langkey="Cancel" onclick="CloseLoginDlg();">Cancel</button>
							<button type="button" class="ximeo_button" data-toggle="button" data-langkey="OK" onclick="CheckUserAccess ();">OK</button>
						</div>
					</div>
				</div>
				
			</div>
		</div>
		
		<div id="IdcUserDiv" class="container-fluid max-vh-100 vh-100 p-0 bg-warning overflow-hidden" style="display: none;">
			<div class="row bg-light w-100 h-100 p-0 m-0">
				<div class="col-md-auto w-100 h-100 p-0 m-0">
					<div id="IdcUserContainer" class="container-fluid d-flex flex-column h-100 w-100 p-0 m-0">
						<div id="IdcUserDivRow1" class="row w-100 p-0 m-0 bg-light border-bottom">
							<div class="col w-100 m-0 p-0">
								<nav id="idnavbar" class="navbar navbar-expand navbar-dark ximeo_bg-dark-1 static-top w-100 p-0 m-0 ps-2 pt-1 pb-1">
									<div class="navbar-collapse collapse w-100 order-1 order-md-0 dual-collapse2 p-0 m-0 pt-2 pb-2">
										<div class="row m-0 p-0">
											<div class="col">
												<a href="http://ximeo.be" class="d-flex align-items-center col-md-3 mb-2 mb-md-0 ms-2 p-0 text-dark text-decoration-none h-100">
													<img src="SubFW/bmp/eoqual.png" alt="eoQUAL" style="width: 110px;">
												</a>
											</div>
											<div class="col">
												<img class="imgclickable" src="SubFW/bmp/menu.png" alt="Left tab width" style="width: 25px;" onclick="OnLeftTabWidth();">
											</div>
										</div>

									</div>
									<div class="navbar-collapse collapse ml-auto order-3 dual-collapse2 me-3">
										<ul class="nav nav-pills ml-auto w-100 m-0 p-0 pe-3">
											<li class="nav-item dropdown">
												
												<a class="nav-link dropdown-toggle text-white fw-bold p-0" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
												
												<img src="SubFW/bmp/person-white.png" style="height:28px; width: auto;">
												<span id="IdcUserName" class="h-100 m-0 p-0 ps-2 align-bottom" style="min-height: 28px !important;"></span>
												</a>
												
												
												<ul class="dropdown-menu dropdown-menu-end bg-white">
													<li class="h-100 m-0 p-0">
														<a class="dropdown-item h-100 m-0 p-0 ps-2 pe-2" href="#" onclick="OnAuthorizedAccess();">
															<div class="h-100 m-0 p-0">
																<img src="SubFW/bmp/access_list_1.png" style="height: 24px; width: auto;">
																<span data-langkey="Authorized access..." class="h-100 m-0 p-0 ps-2 align-bottom" style="min-height: 24px !important;"></span>
															</div>
														</a>
													</li>

													<li class="h-100 m-0 mt-2 p-0 border-top">
														<a class="dropdown-item h-100 m-0 p-0 ps-2 pe-2" href="#" onclick="OnUserLogout();">
															<div class="h-100 m-0 p-0">
																<img src="SubFW/bmp/logout.png" style="height: 24px; width: auto;">
																<span data-langkey="Logout..." class="h-100 m-0 p-0 ps-2 align-bottom" style="min-height: 24px !important;"></span>
															</div>
														</a>
													</li>
												</ul>
											</li>
										</ul>
										<ul class="nav nav-pills ml-auto w-100 m-0 p-0 ps-4">
											<li class="nav-item dropdown">
												<a class="nav-link dropdown-toggle text-white fw-bold p-0" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
													<img src="SubFW/bmp/manual.png" style="height:28px; width: auto;">
												</a>
												<ul class="dropdown-menu dropdown-menu-end bg-white">
													<li class="h-100 m-0 p-0">
														<a class="dropdown-item h-100 m-0 p-0 ps-2 pe-2" onclick="OnHelpHTML();">
															<div class="h-100 m-0 p-0">
																<img src="SubFW/bmp/html.png" style="height: 24px; width: auto;">
																<span data-langkey="HTML format" class="h-100 m-0 p-0 ps-2 align-bottom" style="min-height: 24px !important;"></span>
															</div>
														</a>
													</li>
													<li class="h-100 m-0 mt-2 p-0 border-top">
														<a class="dropdown-item h-100 m-0 p-0 ps-2 pe-2" onclick="OnHelpPDF();">
															<div class="h-100 m-0 p-0">
																<img src="SubFW/bmp/pdf.png" style="height: 24px; width: auto;">
																<span data-langkey="PDF format" class="h-100 m-0 p-0 ps-2 align-bottom" style="min-height: 24px !important;"></span>
															</div>
														</a>
													</li>
												</ul>

											</li>
										</ul>
									</div>
								</nav>
							</div>
						</div>
						
						<div id="IdcUserDivRow2" class="row flex-grow-1 w-100 p-0 m-0" style="min-height: 0;">
							
							<div class="col-md-auto h-100 m-0 p-0 eoqual_left_tabs_bg">
								<div class="d-flex flex-column w-100 h-100">
									<div class="row m-0 p-0">
										<div id="IdcLeftTabsContainer" class="col-md-auto h-100 m-0 p-0 pt-2 ximeo_text-light eoqual_left_tabs_bg">
										</div>
									</div>
									<div class="row flex-grow-1 m-0 p-0" style="min-height: 0px;">
										<div class="col mt-auto m-0 p-0 ps-3 pt-3 pb-3 bg-light border-end">
											<a href="http://ximeo.be" class="d-flex align-items-center col-md-3 mb-2 mb-md-0 text-dark text-decoration-none">
												<img src="SubFW/bmp/ximeo.png" alt="XIMEO" style="width: 90px;">
											</a>
										</div>
									</div>
								</div>
							</div>
					
							<div class="col flex-grow-1 h-100 p-0 bg-light" style="min-width: 0px;">

								<div id="IdcMainContainer" class="h-100 w-100 p-0 m-0" >
									<div id="IdcDivDashboard"  class="ximeo_bg-light w-100 h-100 p-3 m-0" style="display: none !important"></div>
									<div id="IdcDivStatisticContainer"  class="ximeo_bg-light w-100 h-100 p-3 m-0" style="display: none !important"></div>
									<?php include ("SubFW/html/LegalDocument.html"); 					?>	<!-- See page_legal_document.js 		-->
									<?php include ("SubFW/html/LegalDocumentWorking.html");				?>	<!-- See page_legal_document_working.js -->
									<?php include ("SubFW/html/InstitutionalDocument.php"); 			?>	<!-- See visit.js 						-->
									<?php include ("SubFW/html/Procedure.php"); 						?>	<!-- See page_procedure.js				-->
									<?php include ("SubFW/html/ProcedureWorking.php");					?>	<!-- See page_procedure_working.js		-->
									<?php include ("SubFW/html/ExamsList.html"); 						?>	<!-- See page_exams_list.js				-->
									<?php include ("SubFW/html/ExamsListWorking.html");					?>	<!-- See page_exams_list_working.js		-->
									<?php include ("SubFW/html/Staff.php");								?>	
									<?php include ("SubFW/html/Audit.html");							?>	
									<?php include ("SubFW/html/Device.php");							?>	
									<?php include ("SubFW/html/Dosimetry.html");						?>	
									<?php include ("SubFW/html/Incident.html");							?>	
									<?php include ("SubFW/html/Task.html");								?>	
									<?php include ("SubFW/html/TaskWorking.html");						?>	
									<?php include ("SubFW/html/Survey.html");							?>	
									<?php include ("SubFW/html/AllDocuments.html");						?>	
									<?php include ("SubFW/html/Settings.html");							?>	
									<?php include ("SubFW/html/FastIncidentReporting.html");			?>	
								</div>
										
							</div> <!-- col -->
							
	
						</div> <!-- row flex-grow-1 -->
							
					</div>	<!-- container -->
															
				</div>	<!-- col -->
				
			</div>
			
			<?php include ("SubFW/html/msg_dlg.html");					?>
			<?php include ("SubFW/html/waiting.html");					?>
			<?php include ("SubFW/html/DocumentViewer.html");			?>
			<?php include ("SubFW/html/PhotoAlbum.html");				?>
			<?php include ("SubFW/html/EquipmentListing.html");			?>
			<?php include ("SubFW/html/AuthorizedAccess.html");			?>
			<?php include ("SubFW/html/SurveyFieldEdit.html");			?>	
		</div>
		
			
		<script>
			G_ServerAddress = '<?php echo ($config_servernameorip); ?>';
			G_ServerFolder  = '<?php echo ($GLOBALS["EOQUAL_ROOT"]); ?>';

			CurrentLanguage = 'en';

			AddLanguages ();

			switchLanguage ( CurrentLanguage );

			context.init({preventDoubleContext: false});

			console.log ( "pathname : " + window.location.pathname );

			window.addEventListener(`contextmenu`, (e) => {
		 		e.preventDefault();
		 	});

		 	sessionStorage.setItem ( 'MainPageInitialized', 		false  );

		</script>
	
	</body>
	
</html>